** THE IMPACT OF AID ON BUREAUCRATIC QUALITY: DOES THE MODE OF DELIVERY MATTER?
** Pablo Selaya & Rainer Thiele
** J. Int. Dev. 24, 379386 (2012)

clear all
set more off

cd "DESTINATION FOLDER"

use data_cross9505_jid2012, clear

** REGRESSIONS IN DIFFS WITH THE INIT LEVEL AS CONTROL

** TABLE 1: Disaggregated aid and bureaucratic quality (2SLS)
** Aid variables instrumented by population in 1995 and under 5 mortality rate 1995.
** Include only net aid receipients (drop net aid donors)

ivreg2 burqdiff burqinit rgdpchinit (ODA_disbursement_GDPmean    = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012, replace
ivreg2 burqdiff burqinit rgdpchinit (ODAOL_disbursement_GDPmean  = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (ODAOG_disbursement_GDPmean  = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PA_disbursement_GDPmean     = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PAOL_disbursement_GDPmean   = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PAOG_disbursement_GDPmean   = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PROA_disbursement_GDPmean   = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PROAOL_disbursement_GDPmean = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (PROAOG_disbursement_GDPmean = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (BS_disbursement_GDPmean     = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (BSOL_disbursement_GDPmean   = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012
ivreg2 burqdiff burqinit rgdpchinit (BSOG_disbursement_GDPmean   = popinit mortalityunder5init) if ODA_disbursement_GDPmean>0, r first
outreg2 using table1_jid2012

** Test homoskedasticity before applying Moreira (2003) std error correction for weak id.

regress burqdiff burqinit rgdpchinit ODA_disbursement_GDPmean    if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit ODAOL_disbursement_GDPmean  if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit ODAOG_disbursement_GDPmean  if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PA_disbursement_GDPmean     if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PAOL_disbursement_GDPmean   if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PAOG_disbursement_GDPmean   if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PROA_disbursement_GDPmean   if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PROAOL_disbursement_GDPmean if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit PROAOG_disbursement_GDPmean if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit BS_disbursement_GDPmean     if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit BSOL_disbursement_GDPmean   if ODA_disbursement_GDPmean>0
estat hettest, iid
regress burqdiff burqinit rgdpchinit BSOG_disbursement_GDPmean   if ODA_disbursement_GDPmean>0
estat hettest, iid

** TABLE 2: Loans and bureaucratic quality (2SLS - Moreira 2003 correction for weak id.)
** Loan average disbursements instrumented by initial commitments.
** Include only net aid receipients (drop net aid donors)

condivreg burqdiff burqinit rgdpchinit (ODAOL_disbursement_GDPmean  = ODA_commitment_GDPinit)  if ODA_disbursement_GDPmean>0, 2sls ar lm level(90) test(0) 
outreg2 using table2_jid2012, replace
condivreg burqdiff burqinit rgdpchinit (PAOL_disbursement_GDPmean   = PA_commitment_GDPinit)   if ODA_disbursement_GDPmean>0, 2sls ar lm level(90) test(0) 
outreg2 using table2_jid2012
condivreg burqdiff burqinit rgdpchinit (PROAOL_disbursement_GDPmean = PROA_commitment_GDPinit) if ODA_disbursement_GDPmean>0, 2sls ar lm level(90) test(0) 
outreg2 using table2_jid2012
condivreg burqdiff burqinit rgdpchinit (BSOL_disbursement_GDPmean   = BS_commitment_GDPinit)   if ODA_disbursement_GDPmean>0, 2sls ar lm level(90) test(0) 
outreg2 using table2_jid2012

