/*Replication of individual-level regressions*/
use europe_individuals_data, clear

/*Table 5*/
xi: reg hardwork cistercianshare area i.country [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, replace title(Table 5. Values in Europe alternative specifications) addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(*nuts*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country if (rel6==1 | cath==1) [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, cath)  bdec(3) dec(3) nonot label nocons drop(_I*)

xi: reg thrift cistercianshare area i.country [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country if (rel6==1 | cath==1) [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, cath)  bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare cistercian logtotcister cisterdum area logarea age age_sq male mar1 x025 lat_deg4 long_deg4) excel

/*Table 6*/
/*Panel A*/
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, replace title(Table 6. Values in Europe alternative specifications) addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(*nuts*)
xi: reg hardwork cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork cistercian area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
preserve
drop if regexm(nuts2,"Border")==1
xi: reg hardwork cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork cistercian area using values3, append addtext(Country FE, Y, Sample, ex Midland) bdec(3) dec(3) nonot label nocons drop(_I*)
restore
xi: reg hardwork logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork logtotcister logarea using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 hardwork cisterdum logarea using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift cistercian area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
preserve
drop if regexm(nuts2,"Border")==1
xi: reg thrift cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift cistercian area using values3, append addtext(Country FE, Y, Sample, ex Midland) bdec(3) dec(3) nonot label nocons drop(_I*)
restore
xi: reg thrift logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift logtotcister logarea using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 thrift cisterdum logarea using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare cistercian logtotcister cisterdum area logarea age age_sq male mar1 x025 lat_deg4 long_deg4) excel

/*Panel B*/
keep if rel6==1 | cath==1
quietly: xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, replace title(Table 6. Values in Europe alternative specifications) addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(*nuts*)
quietly: xi: reg hardwork cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
preserve
drop if regexm(nuts2,"Border")==1
quietly: xi: reg hardwork cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, ex Midland)  bdec(3) dec(3) nonot label nocons drop(_I*)
restore
quietly: xi: reg hardwork logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg hardwork cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
preserve
drop if regexm(nuts2,"Border")==1
quietly: xi: reg thrift cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, ex Midland)  bdec(3) dec(3) nonot label nocons drop(_I*)
restore
quietly: xi: reg thrift logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 rel1 rel2 rel3 rel4 rel5 rel6 prot i.country [pw=s017], cl(country)
outreg2 using values3, append addtext(Country FE, Y, Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare cistercian logtotcister cisterdum area logarea age age_sq male mar1 x025 lat_deg4 long_deg4) excel

/*Panel C*/
use europe_individuals_data, clear
keep if regexm(nuts1,"England")==1 | regexm(nuts1,"Yorkshire")==1
quietly: xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl(nuts2)
outreg2 hardwork cistercianshare area using values3, replace title(Table 7. Values in Europe alternative specifications) addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(*nuts*)
quietly: xi: reg hardwork cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 hardwork cistercian area using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg hardwork logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 hardwork logtotcister logarea using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg hardwork cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 hardwork cisterdum logarea using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)

quietly: xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift cistercian area age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift logtotcister logarea age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*)
quietly: xi: reg thrift cisterdum logarea age male mar1 age_sq x025 lat_deg4 long_deg4 [pw=s017], cl( nuts2)
outreg2 using values3, append addtext(Sample, full)  bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare cistercian logtotcister cisterdum area logarea age age_sq male mar1 x025 lat_deg4 long_deg4) excel







