/*Replication of individual-level regressions for online appendix*/
use europe_individuals_data, clear

/* Table S10. Restricting Table 5 to ethnic + controlling for institutions */

local if if ethnic==1
local and & ethnic==1

xi: reg hardwork cistercianshare area i.country `if' [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, replace title(Table 5. Values in Europe alternative specifications) addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(*nuts*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country `if' [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country `if' [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country if (rel6==1 | cath==1) `and' [pw=s017], cl(country)
outreg2 hardwork cistercianshare area using values3, append addtext(Country FE, Y, Sample, cath) bdec(3) dec(3) nonot label nocons drop(_I*)

xi: reg thrift cistercianshare area i.country `if' [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country `if' [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 cath rel1 rel2 rel3 rel4 rel5 rel6 prot i.country `if' [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, full) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 i.country if (rel6==1 | cath==1) `and'  [pw=s017], cl(country)
outreg2 thrift cistercianshare area using values3, append addtext(Country FE, Y, Sample, cath) bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare cistercian logtotcister cisterdum area logarea age age_sq male mar1 x025 lat_deg4 long_deg4) excel

/*Table S11. split on agriculture employment*/
areg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, replace title(Table 5. Values for catholics in Europe split on agr) addtext(Country FE, Y, Baseline controls, Y, Sample, full) bdec(3) dec(3) nonot label nocons
areg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. & agremploy2007>45 [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, append addtext(Country FE, Y, Baseline controls, Y, Sample, agr>45) bdec(3) dec(3) nonot label nocons
areg hardwork cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. & agremploy2007<=45 [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, append addtext(Country FE, Y, Baseline controls, Y, Sample, agr<45) bdec(3) dec(3) nonot label nocons

areg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, append addtext(Country FE, Y, Baseline controls, Y, Sample, full) bdec(3) dec(3) nonot label nocons
areg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. & agremploy2007>45 [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, append addtext(Country FE, Y, Baseline controls, Y, Sample, agr>45) bdec(3) dec(3) nonot label nocons
areg thrift cistercianshare area age male mar1 age_sq x025 lat_deg4 long_deg4 if (rel6==1 | cath==1) & agremploy!=. & agremploy2007<=45 [pw=s017], absorb(country) cl(country)
outreg2 hardwork cistercianshare area using agr.xls, append addtext(Country FE, Y, Baseline controls, Y, Sample, agr<45) bdec(3) dec(3) nonot label nocons





