/*Replication of regions regressions*/

use "regions_europe_replicate.dta", clear

/*Figure 7*/
xi: reg hardworkcond cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
*avplot cistercianshare, xtitle(Cistercian share | Wr) ytitle(Hardwork | Wr Wi)

xi: reg thriftcond cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
*avplot cistercianshare, xtitle(Cistercian share | Wr) ytitle(Thrift | Wr Wi)

/*Figure 8*/

xi: reg logrgdpworker2007 cistercianshare area lat_deg4 long_deg4 i.nuts1, cl(country)
gen sample1=e(sample)

local sample if sample1==1
xi: reg logemp2007  logpop2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
avplot logtotcister, xtitle((log) Cistercians | X) ytitle((log) Employment | X)

xi: reg  loggdptot2007 logemp2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
avplot logtotcister, xtitle((log) Cistercians | X) ytitle((log) GDP | X)

/*Table 7*/
local sample if sample1==1

xi: reg logemp2007 cistercianshare  logpop2007 area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, replace title(Table A8. OLS of outcomes on Cistercians across European regions) addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 totcister area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 cisterdum logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)

local sample if sample1==1

xi: reg  loggdptot2007 logemp2007 cistercianshare area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 totcister area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 cisterdum logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare totcister logtotcister cisterdum logpop2007 logemp2007 area logarea) excel
