/*Replication of regions regressions in online appendix*/

use "regions_europe_replicate.dta", clear

xi: reg logrgdpworker2007 cistercianshare area lat_deg4 long_deg4 i.nuts1, cl(country)
gen sample1=e(sample)

/*Table S9*/

xi: reg hardwork cistercianshare area lat_deg4 long_deg4 i.country, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, replace title(Table A7. OLS of values on Cistercians across regions in Europe) addtext(country FE, Y, Sample, full) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardwork cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(country FE, Y, Sample, prot<50%) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardworkcond cistercianshare area lat_deg4 long_deg4 i.country, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, full) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg hardworkcond cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, prot<50%) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)

xi: reg thrift cistercianshare area lat_deg4 long_deg4 i.country, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, full) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thrift cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, prot<50%) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thriftcond cistercianshare area lat_deg4 long_deg4 i.country, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, full) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg thriftcond cistercianshare area lat_deg4 long_deg4 i.country if prot<0.50, cl(country)
quietly: tab country if e(sample)
outreg2 using values1, append addtext(Country FE, Y, Sample, prot<50%) addstat(No. countries, r(r)) bdec(3) dec(3) nonot label nocons drop(_I*) excel


/*Table S13*/
local sample coal if sample1==1

xi: reg logemp2007 cistercianshare  logpop2007 area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, replace title(Table A8. OLS of outcomes on Cistercians across European regions) addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 totcister area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg logemp2007  logpop2007 cisterdum logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logpop2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)

local sample coal if sample1==1

xi: reg  loggdptot2007 logemp2007 cistercianshare area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 totcister area lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 logtotcister logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*)
xi: reg  loggdptot2007 logemp2007 cisterdum logarea lat_deg4 long_deg4 age i.nuts1 `sample', cl(country)
test logemp2007=1
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) addstat(No scale effects p value, r(p)) bdec(3) dec(3) nonot label nocons drop(_I*) sortvar(cistercianshare totcister logtotcister cisterdum logpop2007 logemp2007 area logarea) excel

/*Table S12: Table 7 with hardwork*/
local sample if sample1==1

areg logemp2007 cistercianshare hardwork thrift logpop2007 area lat_deg4 long_deg4 age `sample', cl(country) absorb(nuts1)
test hardwork==thrift==0
outreg2 using outcomes.xls, replace addtext(NUTS1 FE, Y) bdec(3) dec(3) nonot label nocons drop(_I*)

areg logemp2007 totcister hardwork thrift logpop2007 area lat_deg4 long_deg4 age `sample', cl(country) absorb(nuts1)
test hardwork==thrift==0
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) bdec(3) dec(3) nonot label nocons drop(_I*)
areg logemp2007 logtotcister hardwork thrift logpop2007 logarea lat_deg4 long_deg4 age `sample', cl(country) absorb(nuts1)
test hardwork==thrift==0
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) bdec(3) dec(3) nonot label nocons drop(_I*)
areg logemp2007 cisterdum hardwork thrift logpop2007 logarea lat_deg4 long_deg4 age `sample', cl(country) absorb(nuts1)
test hardwork==thrift==0
outreg2 using outcomes.xls, append addtext(NUTS1 FE, Y) bdec(3) dec(3) nonot label nocons drop(_I*)
