/* Replication of results for Cistercians */

use uk_county_data, clear

/*Figure 2*/
bys cist_dum: sum popdens1377
bys cist_dum: sum popdens1600
bys cist_dum: sum popdens1801

* Table 2 * 
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2, r
outreg2 using tabel2.xls, replace bdec(3) dec(3)  nonot label nocons
xi: reg  dlogpopdens1377_1801 cistercianshare logpopdens1377 relhouses agrquality1_2 i.region, r 
outreg2 using tabel2.xls, append bdec(3) dec(3) drop(_I*) nonot label nocons
test  _Iregion_2= _Iregion_3= _Iregion_4= _Iregion_5= _Iregion_6= _Iregion_7= _Iregion_8=0
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 rivershare, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 share_coal, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 ocean, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 roads, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 grass, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 literacy, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons

avplot cistercianshare, mlabel(county)

* Table 3. Other measures of Cistercians *
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2, r
outreg2 using Tabel3.xls, replace bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercian relhouses agrquality1_2, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cist_dum relhouses agrquality1_2, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cist_area relhouses  agrquality1_2, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy1851, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercian relhouses agrquality1_2 logarea share_coal roads literacy1851, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cist_dum relhouses agrquality1_2 logarea share_coal roads literacy1851, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cist_area relhouses  logarea agrquality1_2 share_coal roads literacy1851, r
outreg2 using Tabel3.xls, append  bdec(3) dec(3) nonot label nocons sortvar(cistercianshare cistercian cist_dum cist_area logpopdens1377)

* Table 4. IV *

* second stage *
ivreg2 dlogpopdens1290_1801 logpopdens1290 (cistercianshare=Rforest) agrquality1_2 relhouses grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) replace label
ivreg2 dlogpopdens1290_1801 logpopdens1290 (cist_dum=Rforest) agrquality1_2 relhouses grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) append  label
ivreg2 dlogpopdens1377_1801 logpopdens1377 (cistercianshare=Rforest) relhouses agrquality1_2 grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) append  label
ivreg2 dlogpopdens1377_1801 logpopdens1377 (cist_dum=Rforest) agrquality1_2 relhouses agrquality1_2 grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) append  label
ivreg2 dlogpopdens1600_1801 logpopdens1600 (cistercianshare=Rforest) relhouses agrquality1_2 grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) append  label
ivreg2 dlogpopdens1600_1801 logpopdens1600 (cist_dum=Rforest) relhouses agrquality1_2 grass forestshare, r ffirst
outreg2 using Sscist.xls, adds(K-P, e(widstat), A-R (p-value), e(archi2p)) dec(3) append  label sortvar(cistercianshare cist_dum logpopdens1290 logpopdens1377 logpopdens1600 forestshare)

/*First stage*/
reg cistercianshare logpopdens1290 Rforest agrquality1_2 relhouses grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) replace label
reg cist_dum logpopdens1290 Rforest agrquality1_2 relhouses grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) append  label
reg cistercianshare logpopdens1377 Rforest relhouses agrquality1_2 grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) append  label
reg cist_dum logpopdens1377 Rforest agrquality1_2 relhouses agrquality1_2 grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) append  label
reg cistercianshare logpopdens1600 Rforest relhouses agrquality1_2 grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) append  label
reg cist_dum logpopdens1600 Rforest relhouses agrquality1_2 grass forestshare, r 
outreg2 using Sscist.xls,  dec(3) append  label sortvar(cistercianshare cist_dum Rforest forestshare logpopdens1290 logpopdens1377 logpopdens1600)
