/* Replication of results for Cistercians Online appendix */

use uk_county_data, clear

* Table S1: Table 2 OLS estimation with only not dissolved before 1530

reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2, r
outreg2 using tabel2.xls, replace bdec(3) dec(3)  nonot label nocons
xi: reg  dlogpopdens1377_1801 cistercianshare_1530 logpopdens1377 relhouses agrquality1_2 i.region, r 
outreg2 using tabel2.xls, append bdec(3) dec(3) drop(_I*) nonot label nocons
test  _Iregion_2= _Iregion_3= _Iregion_4= _Iregion_5= _Iregion_6= _Iregion_7= _Iregion_8=0
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 rivershare, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 logarea, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 share_coal, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 ocean, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 roads, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 grass, r
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare_1530 relhouses agrquality1_2 logarea share_coal roads grass, r /*gr videre med share_coal, da hjest R2*/
outreg2 using tabel2.xls, append bdec(3) dec(3) nonot label nocons

/* Table S2: Functional form of initial population density*/

reg dlogpopdens1377_1801 cistercianshare logpopdens1377 relhouses agrquality1_2, r
outreg2 using tabel2_fk.xls, replace bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 cistercianshare logpopdens1377 logpopdens1377_sq relhouses agrquality1_2, r
outreg2 using tabel2_fk.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 cistercianshare popdens1377 relhouses agrquality1_2, r
outreg2 using tabel2_fk.xls, append bdec(3) dec(3)  nonot label nocons
reg dpopdens1377_1801 cistercianshare popdens1377 relhouses agrquality1_2, r
outreg2 using tabel2_fk.xls, append bdec(3) dec(3)  nonot label nocons
reg dpopdens1377_1801 cistercianshare popdens1377 popdens1377_sq relhouses agrquality1_2, r
outreg2 using tabel2_fk.xls, append bdec(3) dec(3)  nonot label nocons sortvar(cistercianshare logpopdens1377 logpopdens1377_sq popdens1377 popdens1377_sq)

* Tabel S3. "falsification" in OLS setting: Impact from Benedictians? *

reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2, r
outreg2 using TableA1, replace  bdec(3) dec(3)  nonot label nocons
xi: reg  dlogpopdens1377_1801 benedictineshare logpopdens1377 relhouses agrquality1_2 i.region, r 
outreg2 using TableA1.xls, append  bdec(3) dec(3)  nonot label nocons  drop(region*)
test  _Iregion_2= _Iregion_3= _Iregion_4= _Iregion_5= _Iregion_6= _Iregion_7= _Iregion_8=0
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 rivershare, r
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 logarea, r
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 share_coal, r
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 ocean, r
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 roads, r
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 grass, r /*g沠videre med share_coal, da h𪥳t R2*/
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons drop(region*)
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 literacy, r /*g沠videre med share_coal, da h𪥳t R2*/
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons drop(region*)
reg dlogpopdens1377_1801 logpopdens1377 benedictineshare relhouses agrquality1_2 logarea share_coal roads literacy, r /*g沠videre med share_coal, da h𪥳t R2*/
outreg2 using TableA1.xls, append bdec(3) dec(3)  nonot label nocons drop(region*)

* Table S4. Appendix controlling for remaining monks*

reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2  logarea share_coal roads literacy, r /*inkluderer kun de signifikante kontroller fra Table 3*/
outreg2 using TableA2.xls, replace bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy benedictineshare, r
outreg2 using TableA2.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy augustinianshare, r
outreg2 using TableA2.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy cluniacshare, r
outreg2 using TableA2.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy premonshare, r
outreg2 using TableA2.xls, append bdec(3) dec(3)  nonot label nocons
reg dlogpopdens1377_1801 logpopdens1377 cistercianshare relhouses agrquality1_2 logarea share_coal roads literacy augustinianshare benedictineshare cluniacshare premonshare, r
test augustinianshare=benedictineshare=cluniacshare=premonshare=0
outreg2 using TableA2.xls, append bdec(3) dec(3)  nonot label nocons sortvar(cistercianshare)

* Table S5. IV falsification: Rforest predicts other houses? placebo "First stage" *

reg cluniacshare logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3.xls, replace 
reg benedictineshare logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3.xls, append 
reg augustinianshare logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3.xls, append 
reg premonshare logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3.xls, append 

* with indicator variable *
gen cluny_dum=(cluniacshare>0) if !missing(cluniacshare)
gen ben_dum=(benedictineshare>0) if !missing(benedictineshare)
gen august_dum=(augustinianshare>0) if !missing(augustinianshare)
gen premon_dum=(premonshare>0) if !missing(premonshare)

reg cluny_dum logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3a.xls, replace 
reg ben_dum logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3a.xls, append 
reg august_dum logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3a.xls, append 
reg premon_dum logpopdens1377 Rforest relhouses forestshare agrquality1_2, r
outreg2 using TableA3a.xls, append 

* Table S6. endogeneity of total religious houses *

reg relhouses logpopdens1290 Rforest  forestshare agrquality1_2 , r
outreg2 using TableA6.xls, replace 
reg relhouses logpopdens1377 Rforest  forestshare agrquality1_2, r
outreg2 using TableA6.xls, append 
reg relhouses logpopdens1600 Rforest  forestshare agrquality1_2, r
outreg2 using TableA6.xls, append 

reg cist_dum logpopdens1290 Rforest  agrquality1_2 forestshare, r
outreg2 using TableA6.xls, append 
reg cist_dum logpopdens1377 Rforest  agrquality1_2 forestshare, r
outreg2 using TableA6.xls, append 
reg cist_dum logpopdens1600 Rforest  agrquality1_2 forestshare, r
outreg2 using TableA6.xls, append 

* Table S7. Placebo *

reg logpopdens1290 Rforest  , r
outreg2 using placebo.xls, replace bdec(3) dec(3)  nonot label nocons
reg logpopdens1377 Rforest  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1600 Rforest  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1801 Rforest  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons

reg logpopdens1290 Rforest forestshare logarea  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1377 Rforest forestshare logarea  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1600 Rforest forestshare logarea , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1801 Rforest forestshare logarea , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons

reg logpopdens1290 Rforest forestshare logarea grass agrquality1_2  , r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1377 Rforest forestshare logarea grass agrquality1_2, r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1600 Rforest forestshare logarea grass agrquality1_2, r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons
reg logpopdens1801 Rforest forestshare logarea grass agrquality1_2, r
outreg2 using placebo.xls, append bdec(3) dec(3)  nonot label nocons

/*Table S8.Interactions*/
gen cistercianshare_area=cistercianshare*area_camp
gen cistercianshare_logarea=cistercianshare*logarea
gen cistercianshare_agrqual=cistercianshare*agrquality1_2
gen cistercianshare_river=cistercianshare*rivershare
gen cistercianshare_ocean=cistercianshare*ocean

label var cistercianshare_area "Cistercianshare X Area"
label var cistercianshare_agrqual "Cistercianshare X Land quality"
label var cistercianshare_river "Cistercianshare X Rivershare"
label var cistercianshare_ocean "Cistercianshare X Ocean"

reg dlogpopdens1377_1801 cistercianshare logpopdens1377  relhouses agrquality1_2, r
outreg2 cistercianshare using Tabel_a9.xls, replace label bdec(3)  addtext(Sample, full, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 
reg dlogpopdens1377_1801 cistercianshare cistercianshare_area area_camp logpopdens1377  relhouses agrquality1_2, r
outreg2 cistercianshare cistercianshare_area using Tabel_a9.xls, append label bdec(3)  addtext(Sample, full, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 
reg dlogpopdens1377_1801 cistercianshare logpopdens1377  relhouses agrquality1_2 if area_camp>2800, r
outreg2 cistercianshare using Tabel_a9.xls, append label bdec(3)  addtext(Sample, median, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 

reg dlogpopdens1377_1801 cistercianshare cistercianshare_agrqual logpopdens1377  relhouses agrquality1_2, r
outreg2 cistercianshare cistercianshare_agrqual using Tabel_a9.xls, append label bdec(3)  addtext(Sample, full, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 
reg dlogpopdens1377_1801 cistercianshare logpopdens1377  relhouses agrquality1_2 if agrquality1_2<0.11 , r
outreg2 cistercianshare using Tabel_a9.xls, append label bdec(3)  addtext(Sample, median, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 

reg dlogpopdens1377_1801 cistercianshare cistercianshare_river logpopdens1377  relhouses agrquality1_2, r
outreg2 cistercianshare cistercianshare_river using Tabel_a9.xls, append label bdec(3)  addtext(Sample, full, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 
reg dlogpopdens1377_1801 cistercianshare logpopdens1377  relhouses agrquality1_2  if rivershare<.113, r
outreg2 cistercianshare using Tabel_a9.xls, append label bdec(3)  addtext(Sample, median, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 

reg dlogpopdens1377_1801 cistercianshare cistercianshare_ocean ocean logpopdens1377  relhouses agrquality1_2, r
outreg2 cistercianshare cistercianshare_ocean using Tabel_a9.xls, append label bdec(3)  addtext(Sample, full, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) 
reg dlogpopdens1377_1801 cistercianshare logpopdens1377  relhouses agrquality1_2 if ocean==0, r
outreg2 cistercianshare using Tabel_a9.xls, append label  addtext(Sample, median, Baseline controls, Y) drop(logpopdens1377  relhouses agrquality1_2 ocean rivershare area_camp) bdec(3)

