*************************************************
* Dofile to replicate all figures and tables in *
*       the paper "Power and Persistence"       *
*************************************************

****************
*** Figure 1 ***
****************

use data_disaggregated, clear

* Size *

keep if size6!=.
keep if size6==1

*number soc: 
corr polity headman

bys cont_broad: corr polity headman

drop if headman==.

collapse polity headman (first) cont_broad, by(country)

corr polity headman

bys cont_broad: corr polity headman

*** Complex ***

use data_disaggregated, clear

keep if compl7!=.
keep if compl7==1

*number soc: 
corr headman polity compl7
bys cont_broad: corr polity headman

drop if headman==.

collapse polity headman (first) cont_broad, by(country)

corr polity headman

bys cont_broad: corr polity headman

* Capitals *

use data_disaggregated, clear

keep if dist_cap400!=.
keep if dist_cap400==1

*number soc: 
corr headman polity dist_cap400
bys cont_broad: corr polity headman

drop if headman==.

collapse polity headman dist_cap400 compl7 (first) cont_broad, by(country)

corr polity headman

bys cont_broad: corr polity headman


***************
*** Table 1 ***
***************

use data_disaggregated, clear

tab v72_v276

*************
**TABLE 2****
*************

use aggregated, clear

label var polity polity

reg polity headman, r
outreg2 using table1, replace title(Table 1. OLS of indigenous election rule on polity) addtext(Region FE, No)  bdec(2) dec(2) nonot label nocons
reg polity headman abslat, r
outreg2 using table1, append  addtext(Region FE, No)   bdec(2) dec(2) nonot label nocons
reg polity headman abslat year, r
outreg2 using table1, append addtext(Region FE, No)   bdec(2) dec(2) nonot label nocons
reg polity headman abslat year complex, r
outreg2 using table1, append addtext(Region FE, No)   bdec(2) dec(2) nonot label nocons
reg polity headman abslat year complex hierarchy, r
outreg2 using table1, append addtext(Region FE, No)   bdec(2) dec(2) nonot label nocons

reg polity headman conjh_*, r
outreg2 using table1, append addtext(Region FE, Yes)  drop(conjh_*)  bdec(2) dec(2) nonot label nocons
reg polity headman abslat conjh_*, r
outreg2 using table1, append  addtext(Region FE, Yes)  drop(conjh_*)   bdec(2) dec(2) nonot label nocons
reg polity headman abslat year conjh_*, r
outreg2 using table1, append addtext(Region FE, Yes) drop(conjh_*)    bdec(2) dec(2) nonot label nocons
reg polity headman abslat year complex conjh_*, r
outreg2 using table1, append addtext(Region FE, Yes) drop(conjh_*)    bdec(2) dec(2) nonot label nocons
reg polity headman abslat year complex hierarchy conjh_*, r
outreg2 using table1, append addtext(Region FE, Yes) drop(conjh_*)    bdec(2) dec(2) nonot label nocons tex(frag)

**********************************
*** Table 3+4 : Complex + size ***
**********************************

use aggregated, clear

*** Have to star out one of the following pairs ***

local controls abslat year
local reg No

local controls abslat year conjh_*
local reg Yes

*** Have to star out one of the following pairs ***

local var complex 
local var2 compl 

local var size 
local var2 size 

label var headman_infl "Indigenous democracy within influential soc"
label var headman_noinfl "Indigenous democracy within non-influential soc"
label var infl "Influential societies as share of total"
label var headman_`var' "Indigenous democracy x `var'"

local if if headman_`var'!=.

reg polity headman `controls', r
outreg2 using `var'_table.tex, replace addtext(Region FE, `reg', Cutoff, .) keep(headman headman_`var') bdec(2) dec(2) nonot label nocons

reg polity headman headman_`var' `var' `controls' , r
outreg2 using `var'_table.tex, append addtext(Region FE, `reg', Cutoff, .) keep(headman headman_`var') bdec(2) dec(2) nonot label nocons

foreach x in 2 3 4 5 6 7 8{
replace headman_infl=headman_`var2'`x'
replace headman_noinfl=headman_no`var2'`x'
replace infl=`var2'`x'
local infl headman_infl headman_noinfl infl

reg polity `infl' `controls', r
outreg2 using `var'_table.tex, append addtext(Region FE, `reg', Cutoff, `x') keep(headman_infl headman_noinfl infl) bdec(2) dec(2) nonot label nocons tex(frag)
}

***************
*** Table 5 ***
***************

use aggregated, clear

****PANEL A: WITHOUT CONTINENT FE****

local controls abslat year lnarea lndist_ocean 

label var headman_lndist "Indigenous democracy x (ln) Distance to the capital"

reg polity headman `controls', r
outreg2 using increment_table.tex, replace title(Table 5. Headman on polity with distance-increments) addtext(Region FE, No, Cutoff, .) bdec(2) dec(2) nonot label nocons
reg polity headman headman_lndist lndist_cap `controls', r
outreg2 using increment_table.tex, append addtext(Region FE, No, Cutoff, .) bdec(2) dec(2) nonot label nocons tex(frag)

foreach x in 100 200 300 400 500 600 700 800 900 1000{
replace headman_close=headman_dist_cap`x'
replace headman_far=headman_nodist_cap`x'
replace close=dist_cap`x'
reg polity headman_close headman_far close `controls', r
outreg2 using increment_table.tex, append addtext(Region FE, No, Cutoff, `x') drop(con_* capcon_* reg_* abslat year complex lnarea lndist_ocean close) bdec(2) dec(2) nonot label nocons tex(frag)
}

****PANEL B: WITH CONTINENT FE*******

local controls abslat year lnarea lndist_ocean 

reg polity headman conjh_* `controls', r
outreg2 using increment_table3.tex, replace title(Table 5. Headman on polity with distance-increments) addtext(Region FE, Yes, Cutoff, .) drop(con_* capcon_* reg_* conjh* abslat year complex lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons
reg polity headman headman_lndist lndist_cap conjh_* `controls', r
outreg2 using increment_table3.tex, append addtext(Region FE, Yes, Cutoff, `x') bdec(2) dec(2) nonot label nocons tex(frag)

foreach x in 100 200 300 400 500 600 700 800 900 1000{
replace headman_close=headman_dist_cap`x'
replace headman_far=headman_nodist_cap`x'
replace close=dist_cap`x'
reg polity headman_close headman_far close `controls' conjh_*, r
outreg2 using increment_table3.tex, append addtext(Region FE, Yes, Cutoff, `x') bdec(2) dec(2) nonot label nocons tex(frag)
}

***************************
***TABLE 6: Colonization***
***************************

cd "C:\Users\hpv239\Dropbox\Roots of democracy\Data"

use aggregated, clear

local vars headman_size6 headman_nosize6 size6
local a size
local interaction headman_size_set size_set

local vars headman_compl7 headman_nocompl7 compl7
local a complex
local interaction headman_compl_set compl_set

local vars headman_close headman_far close lnarea lndist_ocean
local a dist
local interaction headman_close_set close_set

*Determinants of colonization
reg polity `vars' abslat year conjh_* if conjh_3!=1 `and', r
outreg2 using table4`a', replace title(Table 7. Indigenous Roots and colonialism) addtext(Region FE, Yes) keep(`vars') bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  statehist_pre1500 if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars' statehist_pre1500) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year  conjh_*  malaria rugged tempavr precavr landlocked distocean100 if conjh_3!=1, r
test malaria=rugged=landlocked=tempavr=precavr=distocean100=0
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars') addstat(p-value of geo controls, r(p)) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year  conjh_* pd1500 if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars' pd1500) bdec(2) dec(2) nonot label nocons
*Colonization, colonizer, and type of colonization
 reg polity `vars' abslat year conjh_*  colony if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars' colony) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  colony_* if conjh_3!=1, r
test colony_esp=colony_fra=colony_prt=colony_oeu=colony_gbr
outreg2 using table4`a', append addtext(Region FE, Yes) addstat(p-value of colony controls, r(p)) keep(`vars') bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  col_dur2 if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars'  col_dur2) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  col_dur if conjh_3!=1 & country!="Russia", r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars'  col_dur) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  eurfrac if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars' eurfrac) bdec(2) dec(2) nonot label nocons
reg polity `vars' abslat year conjh_*  indirect2 if conjh_3!=1, r
outreg2 using table4`a', append addtext(Region FE, Yes) keep(`vars' indirect2) bdec(2) dec(2) nonot label nocons tex(frag)

***********************
*Table 7. Persistence *
***********************

use aggregated, clear

* Put the appropriate vars and controls in the bottom
* This setting makes table for complex*/

local vars headman_dist_cap400 headman_nodist_cap400 dist_cap400
local vars headman_size6 headman_nosize6 size6
local vars headman_compl7 headman_nocompl7 compl7

local controls abslat year conjh_* eurfrac lndist_ocean lnarea /* Controls for distance */
local controls abslat year conjh_* eurfrac                     /* Controls for size+compål*/

local type meanpolyarc

reg `type'_1900_25 `vars' `controls', r
outreg2 using demoyear, replace keep(`vars') addtext(Current demo measure, V-dem) bdec(3) dec(3) nonot label nocons 
reg `type'_1925_50 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, V-dem) bdec(3) dec(3) nonot label nocons  
reg `type'_1950_75 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, V-dem) bdec(3) dec(3) nonot label nocons 
reg `type'_1975_00 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, V-dem) bdec(3) dec(3) nonot label nocons

local type meanpolity2

reg `type'_1900_25 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, polity) bdec(3) dec(3) nonot label nocons 
reg `type'_1925_50 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, polity) bdec(3) dec(3) nonot label nocons  
reg `type'_1950_75 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, polity) bdec(3) dec(3) nonot label nocons 
reg `type'_1975_00 `vars' `controls', r
outreg2 using demoyear, append keep(`vars') addtext(Current demo measure, polity) bdec(3) dec(3) nonot label nocons  tex(frag)

*******************************************
*** Table 8. Disturbance of persistence ***
*******************************************

use aggregated, clear

gen headman_infl_disturb=.
gen infl_disturb=.
gen disturb=.

local var dist_cap400
local var compl7
local var size6

local int settle_col

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

local vars headman_infl headman_noinfl infl headman_infl_disturb infl_disturb disturb

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1 , r
test headman_infl=headman_infl_disturb
outreg2 using table4, replace addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int eurfrac

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1, r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int col_dur

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

local and & country!="Russia"

reg polity `vars' abslat year conjh_* colony_* `capcontrols' if conjh_3!=1 `and', r
gen sample=e(sample)
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local var compl7

local int settle_col

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1, r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int eurfrac

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1, r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int col_dur

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

local and & country!="Russia"

reg polity `vars' abslat year conjh_* colony_* `capcontrols' if conjh_3!=1 `and', r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local var dist_cap400

local capcontrols lnarea lndist_ocean

local int settle_col

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1, r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int eurfrac

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

reg polity `vars' abslat year conjh_* `capcontrols' if conjh_3!=1, r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +)

local int col_dur

replace headman_infl_disturb=headman_`var'_`int'
replace infl_disturb=`var'_`int'
replace disturb=`int'

local and & country!="Russia"

reg polity `vars' abslat year conjh_* colony_* `capcontrols' if conjh_3!=1 `and', r
outreg2 using table4, append addtext(Region FE, Yes, Disturbance, `int') keep(headman_infl headman_noinfl infl headman_infl_disturb disturb infl_disturb) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.1, 0.15) symbol(***, **, *, +) tex(frag)

**********************************
***TABLE 9: Additional controls***
***+ table A14 = same with beta***
**********************************

cd "C:\Users\hpv239\Dropbox\Roots of democracy\Data"

use aggregated, clear

label var lnrgdp "(log) GDP per capita 2000"
label var prot00 "Protestant share 2000"
label var muslim00 "Muslim share 2000"
label var ethnic "Ethnic fractionalization"
label var language "Linguistic fractionalization"
label var religion "Religious fractionalization"
label var oilpop2000 "Oil (1000 barrels) 2000 per capita"

label var polity polity

local controls year abslat conjh_*

local beta1 beta        /*Star out if not estimating standardized betas*/
local beta2 stats(beta) /*Star out if not estimating standardized betas*/

local var size6 

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

label var headman_infl "Indigenous democracy x influential society"
label var headman_noinfl "Indigenous democracy x non-influential society"

reg polity headman_infl headman_noinfl infl `controls' lnrgdp  , r `beta1'
outreg2 using table8`a'.tex, replace `beta2' keep(headman_infl headman_noinfl lnrgdp) title(Table 5. Correlates of Democracy) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' prot00  muslim00  , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl prot00 muslim00) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' ethnic language religion , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl ethnic language religion) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' oilpop2000, r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl oilpop2000) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons

local var compl7
replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

reg polity headman_infl headman_noinfl infl `controls' lnrgdp  , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl lnrgdp) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' prot00  muslim00  , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl prot00 muslim00) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' ethnic language religion , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl ethnic language religion) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' oilpop2000, r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl oilpop2000) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons

local var dist_cap400
replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

local controls year abslat conjh_* lnarea lndist_ocean

reg polity headman_infl headman_noinfl infl `controls' lnrgdp  , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl lnrgdp) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' prot00  muslim00  , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl prot00 muslim00) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' ethnic language religion , r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl ethnic language religion) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons  
reg polity headman_infl headman_noinfl infl `controls' oilpop2000, r `beta1'
outreg2 using table8`a'.tex, append `beta2' keep(headman_infl headman_noinfl oilpop2000) sortvar(headman_infl headman_noinfl lnrgdp) addtext(Continents, Yes) bdec(2) dec(2) nonot label nocons tex(frag)





*****************************************************************************************
************************************ APPENDIX TABLES ************************************
*****************************************************************************************

****************
*** Table A1 ***
****************

use aggregated, clear

sum polity headman size size6 complex compl7 dist_cap dist_cap400 year if headman!=. & polity!=.
sutex2 polity headman size size6 complex compl7 dist_cap dist_cap400 year if headman!=. & polity!=., minmax

***************
** Table A2. **

use data_disaggregated, clear

tab decade

******************************************************************
*** Table A3. Alternative aggregation method, size and complex ***
******************************************************************

*** Panel A and B ***

* Put the set of local var in the bottom that you want to estimate.
* This setting produces tables for size.

local var2 complex
local var compl

local var size
local var2 size

use data_disaggregated, clear

keep if `var2'!=.

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, replace title(Alternative weights) addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

use data_disaggregated, clear

sum `var2'
gen `var2'w2=`var2'/r(max)

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country [pw=`var2'w2], by(iso3)

reg polity headman abslat year conjh_* `var3', r
outreg2 using table.tex, append addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

foreach x in 2 3 4 5 6 7 8{
use data_disaggregated, clear

gen `var'w=`var'`x'
replace `var'w=0.1 if `var'w==0

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country [pw=`var'w], by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, append addtext(Cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
}

*** Panel A1 and B1***

local var2 complex
local var compl

local var size
local var2 size

use data_disaggregated, clear

keep if `var2'!=.

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, replace title(Alternative weights) addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, append addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

use data_disaggregated, clear


foreach x in 2 3 4 5 6 7 8{
use data_disaggregated, clear

keep if `var'`x'==1

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, append addtext(Cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
}

*** Panels A2 and B2: Placebo ***

local var compl
local var size

use data_disaggregated, clear

keep if `var'2==0

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, replace title(Alternative weights placebo) addtext(Opposite cutoff, 2) keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

foreach x in 3 4 5 6 7 8{
use data_disaggregated, clear

keep if `var'`x'==0

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, append addtext(Opposite cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
}

**********************************************************
*** Table A4. Alternative aggregation method, distance ***
**********************************************************

*** Panel A. ***

use data_disaggregated, clear

local var dist_cap

keep if `var'!=.

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_* lnarea lndist_ocean, r
outreg2 using table.tex, replace title(Alternative weights) addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons

use data_disaggregated, clear

sum `var'
gen `var'w2=1/`var'

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country [pw=`var'w2], by(iso3)

reg polity headman abslat year conjh_* lnarea lndist_ocean, r
outreg2 using table.tex, append addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons


foreach x in 100 200 300 400 500 600 700 800 900 1000{
use data_disaggregated, clear

gen `var'w=`var'`x'
replace `var'w=0.1 if `var'w==0

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country [pw=`var'w], by(iso3)

reg polity headman abslat year conjh_*, r
outreg2 using table.tex, append addtext(Cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +) tex(frag)
}

** Panel B **

use data_disaggregated, clear

local var dist_cap

keep if `var'!=.

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_* lnarea lndist_ocean, r
outreg2 using table.tex, replace title(Alternative weights) addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons

use data_disaggregated, clear

sum `var'
gen `var'w2=1/`var'

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country [pw=`var'w2], by(iso3)

reg polity headman abslat year conjh_* lnarea lndist_ocean, r
outreg2 using table.tex, append addtext(Cutoff, .) keep(headman) bdec(2) dec(2) nonot label nocons

foreach x in 100 200 300 400 500 600 700 800 900 1000{
use data_disaggregated, clear

keep if `var'<`x'

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_* lnarea lndist_ocean, r
outreg2 using table.tex, append addtext(Cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons
}

*** Panel C. placebo ***

local var dist_cap

use data_disaggregated, clear

keep if `var'>100

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_* lndist_ocean lnarea , r
outreg2 using table.tex, replace title(Alternative weights placebo) addtext(Opposite cutoff, 100) keep(headman) bdec(2) dec(2) nonot label nocons

foreach x in 200 300 400 500 600 700 800 900 1000{
use data_disaggregated, clear

keep if `var'>`x'

collapse polity headman abslat conjh_* year lndist_ocean lnarea (first) country, by(iso3)

reg polity headman abslat year conjh_* lndist_ocean lnarea , r
outreg2 using table.tex, append addtext(Opposite cutoff, `x') keep(headman) bdec(2) dec(2) nonot label nocons
}

****************************************
* Table A5. Different headman measures *
****************************************

cd "C:\Users\hpv239\Dropbox\Roots of democracy\Data"

use aggregated, clear

* This program makes program for the local var put in the bottom
* Remember to put the correct set of controls also in the bottom
* As it is set here, it makes table for distance

local var size6
local var compl7
local var dist_cap400

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

label var headman_infl "Indigenous democracy x influential society"
label var headman_noinfl "Indigenous democracy x non-influential society"
label var polity polity

local controls abslat year conjh_*                     /*controls for size and complex*/
local controls abslat year conjh_* lnarea lndist_ocean /*controls for distance*/

reg polity headman_infl headman_noinfl infl `controls', r
outreg2 using headman_other.tex, replace keep(headman_infl headman_noinfl) title(Table x. Headman on polity with alternative measures of headman) addtext(Region FE, Yes, Headman measure, org) bdec(2) dec(2) nonot label nocons

foreach x in 1 2 3 4 5{
replace headman_infl=headman`x'_`var'
replace headman_noinfl=headman`x'_no`var'
replace infl=`var'

local controls abslat year conjh_*                        /*controls for size and complex*/
local controls abslat year conjh_* lnarea lndist_ocean    /*controls for distance*/

reg polity headman_infl headman_noinfl infl `controls', r
outreg2 using headman_other.tex, append keep(headman_infl headman_noinfl) addtext(Region FE, Yes, Headman measure, `x') bdec(2) dec(2) nonot label nocons
}

************************************************
* Table A6. Correlates of indigenous democracy *
************************************************

use data_disaggregated, clear

*pwcorr   headman v3 v5 plough agrsuit_mean_ethno soil12_ethno precipitation_ethno temperature_ethno rugged_mean remote1 lndist_cap complex size hierarchy centralized integration  , star(0.05) sig 

label var abslat_ethno "Absolute latitude"
label var v3 "Dependence on fishing"
label var v5 "Dependence on agriculture"
label var plough "Presence of the plough"
label var agrsuit_mean_ethno "Agricultural suitability"
label var soil12_ethno "Soil constraints"
label var precipitation_ethno "Average precipitation"
label var temperature_ethno "Average temperature"
label var rugged_mean "Ruggedness"
label var remote1 "Remoteness"
label var lndist_cap "(ln) Distance to capital"
label var lndist_centroid "(ln) Distance to cntr centroid"
label var lnarea "(ln) Country area"
label var lndist_ocean "(ln) Distance to the ocean"
label var complex "Societal complexity"
label var size "Mean population size"
label var hierarchy "Jurisdictional hierarchy"
label var centralized "Centralized"
label var integration "Political integration"
*corrtex  headman v3 v5 plough agrsuit_mean_ethno soil12_ethno precipitation_ethno temperature_ethno rugged_mean remote1 lndist_cap lndist_centroid complex size hierarchy centralized integration , file(CorrTable) replace land sig dig(2)

****************
*** Table A7 ***
****************

local controls conjh_* year abslat

/*Type of subsistence, geo, development*/
quietly: reg headman v3 `controls', r
outreg2 using headman.tex, replace title(Determinants of indigenous demo) keep(v3) bdec(2) dec(2) nonot label nocons  

foreach var of varlist v5 plough agrsuit_mean_ethno soil12_ethno precipitation_ethno temperature_ethno rugged_mean remote1 lndist_cap lndist_centroid lnarea lndist_ocean complex size hierarchy centralized integration{

quietly: reg headman `var' `controls', r
outreg2 using headman.tex, append keep(`var') bdec(2) dec(2) nonot label nocons tex(frag)
}

**************************************
*** Table A8. At the country level ***
**************************************

use aggregated, clear

label var abslat_ethno "Absolute latitude"
label var v3 "Dependence on fishing"
label var v5 "Dependence on agriculture"
label var plough "Presence of the plough"
label var agrsuit_mean_ethno "Agricultural suitability"
label var soil12_ethno "Soil constraints"
label var precipitation_ethno "Average precipitation"
label var temperature_ethno "Average temperature"
label var rugged_mean "Ruggedness"
label var remote1 "Remoteness"
label var lndist_cap "(ln) Distance to capital"
label var lndist_centroid "(ln) Distance to cntr centroid"
label var lnarea "(ln) Country area"
label var lndist_ocean "(ln) Distance to the ocean"
label var complex "Societal complexity"
label var size "Mean population size"
label var hierarchy "Jurisdictional hierarchy"
label var centralized "Centralized"
label var integration "Political integration"
label var polity "polity"

local controls conjh_* abslat year

quietly: reg polity v3 `controls', r
outreg2 using headman.tex, replace keep(v3) bdec(2) dec(2) nonot label nocons  

foreach var of varlist v5 plough agrsuit_mean_ethno soil12_ethno precipitation_ethno temperature_ethno rugged_mean remote1 lndist_cap lndist_centroid lnarea lndist_ocean complex size hierarchy centralized integration{

quietly: reg polity `var' `controls', r
outreg2 using headman.tex, append keep(`var') bdec(2) dec(2) nonot label nocons tex(frag)
}

******************************
*** Table A9. With headman ***
******************************

use aggregated, clear

label var abslat_ethno "Absolute latitude"
label var v3 "Dependence on fishing"
label var v5 "Dependence on agriculture"
label var plough "Presence of the plough"
label var agrsuit_mean_ethno "Agricultural suitability"
label var soil12_ethno "Soil constraints"
label var precipitation_ethno "Average precipitation"
label var temperature_ethno "Average temperature"
label var rugged_mean "Ruggedness"
label var remote1 "Remoteness"
label var lndist_cap "(ln) Distance to capital"
label var lndist_centroid "(ln) Distance to cntr centroid"
label var lnarea "(ln) Country area"
label var lndist_ocean "(ln) Distance to the ocean"
label var complex "Societal complexity"
label var size "Mean population size"
label var hierarchy "Jurisdictional hierarchy"
label var centralized "Centralized"
label var integration "Political integration"
label var polity "polity"

* Move around the local controls and head to estimate for each of the power measures.
* This setting calculates for complexity

local controls abslat year conjh_* lndist_ocean lnarea 
local controls abslat year conjh_*

local head headman_size6 headman_nosize6 size6
local head headman_dist_cap400 headman_nodist_cap400 dist_cap400
local head headman_compl7 headman_nocompl7 compl7

quietly: reg polity `head' v3 `controls', r
outreg2 using headman.tex, replace keep(`head') bdec(2) dec(2) nonot label nocons  

foreach var of varlist v5 plough agrsuit_mean_ethno soil12_ethno precipitation_ethno temperature_ethno rugged_mean remote1 lndist_cap lndist_centroid lnarea lndist_ocean complex size hierarchy centralized integration{

quietly: reg polity `head' `var' `controls', r
outreg2 using headman.tex, append keep(`head') bdec(2) dec(2) nonot label nocons tex(frag)
}

*******************************************
*** Table A10. Power measure correlates ***
*******************************************

use data_disaggregated, clear

* Panel A

corr size6 compl7 dist_cap400 

corrtex size6 compl7 dist_cap400, file(CorrTable) replace sig dig(2)

* Panel B

reg size6 year abslat conjh_*, r
predict size6_c, res

reg compl7 year abslat conjh_*, r
predict compl7_c, res

reg dist_cap400 year abslat conjh_*, r
predict dist_cap400_c, res

corrtex size6_c compl7_c dist_cap400_c, file(CorrTable) replace sig dig(2)

********************************************
*** Table A11. Alternative power measure ***
********************************************

use aggregated, clear

replace headman_infl=headman_power2
replace headman_noinfl=headman_nopower2
replace infl=power2

reg polity headman headman_infl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, replace title(Aggregated power measures) addtext(Region FE, Yes, Power, either) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons

reg polity headman_infl headman_noinfl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, append addtext(Region FE, Yes, Power, either) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons

replace headman_infl=headman_power3
replace infl=power3


reg polity headman headman_infl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, append addtext(Region FE, Yes, Power, sum) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons

replace headman_infl=headman_power31
replace headman_noinfl=headman_nopower31
replace infl=power31

reg polity headman_infl headman_noinfl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, append addtext(Region FE, Yes, Power, sum>0) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons

replace headman_infl=headman_power32
replace headman_noinfl=headman_nopower32
replace infl=power32

reg polity headman_infl headman_noinfl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, append addtext(Region FE, Yes, Power, sum>1) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons

replace headman_infl=headman_power33
replace headman_noinfl=headman_nopower33
replace infl=power33

reg polity headman_infl headman_noinfl infl conjh_* abslat lndist_ocean lnarea, r
outreg2 using power.tex, append addtext(Region FE, Yes, Power, sum>2) keep(headman headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons tex(frag)


*************************************
*        Table A12. Putterman       *
*************************************

use aggregated, clear

local controls conjh_* abslat year

local var size6

local perc perc_headman_`var' /* Indicates how large a fraction of the population is caught in the calculation */
local put headman_`var'_putter

replace headman_infl=headman_`var'_putter
replace headman_noinfl= headman_no`var'_putter
replace infl=`var'_putter

reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3, r
outreg2 using headman.tex, replace keep(headman_infl headman_noinfl)  bdec(2) dec(2) nonot label nocons title(Putterman correction) 
*addtext(Power measure, Size, Putterman correction, Yes) 

reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & headman_size6!=., r
outreg2 using headman.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons 
*addtext(Power measure, Size, Putterman correction, Yes) 
replace headman_infl=headman_`var'
replace headman_noinfl= headman_no`var'
replace infl=`var'
reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & `put'!=., r
outreg2 using headman.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Size, Putterman correction, No) 
local var compl7

local perc perc_headman_`var'
local put headman_`var'_putter

replace headman_infl=headman_`var'_putter
replace headman_noinfl= headman_no`var'_putter
replace infl=`var'_putter

reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3, r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Complex, Putterman correction, Yes)

reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & headman!=., r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Complex, Putterman correction, Yes)
replace headman_infl=headman_`var'
replace headman_noinfl= headman_no`var'
replace infl=`var'
reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & `put'!=., r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Complex, Putterman correction, No)
local var dist_cap400

local perc perc_headman_`var'
local put headman_`var'_putter

replace headman_infl=headman_`var'_putter
replace headman_noinfl= headman_no`var'_putter
replace infl=`var'_putter

reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3, r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Capital, Putterman correction, Yes)
reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & headman!=., r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  
*addtext(Power measure, Capital, Putterman correction, Yes)
replace headman_infl=headman_`var'
replace headman_noinfl= headman_no`var'
replace infl=`var'
reg polity headman_infl headman_noinfl infl `controls' if `perc'>0.3 & `put'!=., r
outreg2 using headman.tex, append  keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  tex(frag)
*addtext(Power measure, Capital, Putterman correction, No)

*********************
***** Table A13 *****
*********************

cd "C:\Users\hpv239\Dropbox\Roots of democracy\Data"

use aggregated, clear

local vars headman_dist_cap400 headman_nodist_cap400 dist_cap400 lnarea lndist_ocean
local a dist_cap400
local beta headman_dist_cap400

local vars headman_size6 headman_nosize6 size6
local a size6
local beta headman_size6

local vars headman_compl7 headman_nocompl7 compl7
local a compl7
local beta headman_compl7

reg polity `vars' abslat year conjh_*, r
outreg2 using new2`a'.tex, replace addtext(Regional FE, Yes, Sample, Full) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons  

reg polity `vars' abslat year conjh_*  if conjh_3!=1 & iso3!="USA" & iso3!="CAN" & iso3!="AUS" & iso3!="NZL", r
outreg2 using new2`a'.tex, append addtext(Regional FE, Yes, Sample, Ex Neo Europe) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons  

use data_disaggregated, clear
sum year, det

drop if year<=r(p10)

collapse `vars' polity year conjh_* abslat, by(iso3)

reg polity `vars' abslat year conjh_*, r
outreg2 using new2`a'.tex, append addtext(Regional FE, Yes, Sample, Ex early decile) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons  

use data_disaggregated, clear

sum year, det
drop if year>r(p90)
collapse `vars' polity year conjh_* abslat, by(iso3)

reg polity `vars' abslat year conjh_*, r
outreg2 using new2`a'.tex, append addtext(Regional FE, Yes, Sample, Ex late decile) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons  

use aggregated, clear

*influential obs
reg polity `vars' abslat year conjh_*
predict leverage, leverage
predict covratio, covratio
predict cooksd, cooksd
gen lev=0
replace lev=1 if abs(leverage)>(2*e(rank)+2)/e(N) & leverage!=. & `beta'!=. & polity!=.
gen cook=0
replace cook=1 if cooksd>1 & cooksd!=. & `beta'!=. & polity!=.

**cooks
reg polity `vars' abslat year conjh_* if cook!=1, r
outreg2 using new2`a'.tex, append addtext(Regional FE, Yes, Sample, Ex outliers) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons  
**Leverage
reg polity `vars' abslat year conjh_* if lev!=1  , r
outreg2 using new2`a'.tex, append addtext(Regional FE, Yes, Sample, Ex outliers) drop(conjh_* capcon_* year abslat complex close lnarea lndist_ocean) bdec(2) dec(2) nonot label nocons tex(frag) 

****************************
** Table A14: See Table 9 **
****************************

**********************************************
* Table A15. Different measures of democracy *
**********************************************

cd "C:\Users\hpv239\Dropbox\Roots of democracy\Data"

use aggregated, clear

label var meanpolity1990_00 polity
label var meanpolity2000_10 polity
label var meanPolRights_1990_10 FH

local var size6

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

local controls abslat conjh_* year

reg meanpolity1990_00 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, replace title(Years) keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
reg meanpolity2000_10 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)  
reg meanPolRights_1990_10 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)

local type meanPolRights_1990_10

reg `type' headman_infl headman_noinfl infl `controls'

predict leverage, leverage
gen lev=0
replace lev=1 if abs(leverage)>(2*e(rank)+2)/e(N) & leverage!=. & polity!=.

reg `type' headman_infl headman_noinfl infl `controls' if lev!=1, r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)  tex(frag)

local var compl7

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

reg meanpolity1990_00 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
reg meanpolity2000_10 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
reg meanPolRights_1990_10 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
drop leverage lev

local type meanPolRights_1990_10

reg `type' headman_infl headman_noinfl infl `controls'

predict leverage, leverage
gen lev=0
replace lev=1 if abs(leverage)>(2*e(rank)+2)/e(N) & leverage!=. & polity!=.

reg `type' headman_infl headman_noinfl infl `controls' if lev!=1, r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)  tex(frag)

local var dist_cap400

replace headman_infl=headman_`var'
replace headman_noinfl=headman_no`var'
replace infl=`var'

local controls abslat conjh_* year lndist_ocean lnarea

reg meanpolity1990_00 headman_infl headman_noinfl infl `controls' , r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
reg meanpolity2000_10  headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)
reg meanPolRights_1990_10 headman_infl headman_noinfl infl `controls', r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +) tex(frag)
drop leverage lev

local type meanPolRights_1990_10

reg `type' headman_infl headman_noinfl infl `controls'

predict leverage, leverage
gen lev=0
replace lev=1 if abs(leverage)>(2*e(rank)+2)/e(N) & leverage!=. & polity!=.

reg `type' headman_infl headman_noinfl infl `controls' if lev!=1, r
outreg2 using table_demo.tex, append keep(headman_infl headman_noinfl) bdec(2) dec(2) nonot label nocons  alpha(0.01, 0.05, 0.10, 0.15) symbol(***, **, *, +)  tex(frag)


