/*****************************************************************************/
/*** DESCRIPTION: REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:     EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/*****************************************************************************/

/***********************************************************************************/
/* TABLE: Summary Statistics of Variables from the Baseline Cross-Country Analysis */
/***********************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_stats.log", text replace ;

/*****************************************/
/* Load the AAGK cross-sectional dataset */
/*****************************************/

use "../../data/aagk_xcountry.dta", clear ;

/************************************************************************/
/* Apply log transformations to variables as in the regression analysis */
/************************************************************************/

gen lnnum_ccst_60_17_avg_pri1 = ln(1 + num_ccst_60_17_avg_pri1) ;

/***************************************************/
/* Rescale variables as in the regression analysis */
/***************************************************/

foreach var of varlist abslat ruggavg elevavg elevrng distcr { ;
  replace `var' = `var' / 1000 ;
} ;

replace mdist_addis = mdist_addis / 10 ;

/*******************************************************/
/* Assign appropriate labels to variables for printing */
/*******************************************************/

/* Conflict outcome */
label variable num_ccst_60_17_avg_pri1 "New civil conflict onsets per year, 1960--2017" ;

/* Diversity variables */
label variable pdiv_aa   "Population diversity (ancestry adjusted)" ;
label variable efrac     "Ethnic fractionalization" ;
label variable des_pol15 "Ethnolinguistic polarization" ;

/* Geographical variables */
label variable abslat      "Absolute latitude" ;
label variable ruggavg     "Ruggedness" ;
label variable elevavg     "Mean elevation" ;
label variable elevrng     "Range of elevation" ;
label variable suitavg     "Mean land suitability" ;
label variable suitrng     "Range of land suitability" ;
label variable distcr      "Distance to nearest waterway" ;
label variable island      "Island nation dummy" ;
label variable mdist_addis "Migratory distance from East Africa (in 10,000 km)" ;

/* Deep institutional variables */
label variable evercol_gbr "Ever a U.K. colony dummy" ;
label variable evercol_fra "Ever a French colony dummy" ;
label variable evercol_oth "Ever a non-U.K./non-French colony dummy" ;
label variable legor_uk    "British legal origin dummy" ;
label variable legor_fr    "French legal origin dummy" ;

/* Contemporary institutional variables */
label variable xconst_1960_2017_avg_p4_v17 "Executive constraints, 1960--2017 average" ;
label variable democ_1960_2017_shr_p4_v17  "Fraction of years under democracy, 1960--2017" ;
label variable autoc_1960_2017_shr_p4_v17  "Fraction of years under autocracy, 1960--2017" ;

/* Oil, population, and income variables */
label variable anypetroleum_pet                 "Oil or gas reserve discovery" ;
label variable lnpop_1960_2017_avg_wdi          "Log population, 1960--2017 average" ;
label variable lngdppc_cu_usd_1960_2017_avg_wdi "Log GDP per capita, 1960--2017 average" ;

/*************************************************************************************/
/* Create global macro lists of the relevant covariates from the regression analysis */
/*************************************************************************************/

global ethfrac "efrac" ;
global ethpolr "des_pol15" ;
global geovars "abslat ruggavg elevavg elevrng suitavg suitrng distcr island" ;
global colhist "evercol_gbr evercol_fra evercol_oth" ;
global legalor "legor_uk legor_fr" ;
global exconst "xconst_1960_2017_avg_p4_v17" ;
global polregs "democ_1960_2017_shr_p4_v17 autoc_1960_2017_shr_p4_v17" ;
global oilprod "anypetroleum_pet" ;
global popsize "lnpop_1960_2017_avg_wdi" ;
global ypercap "lngdppc_cu_usd_1960_2017_avg_wdi" ;

/*********************************/
/* Generate the sample indicator */
/*********************************/

qui egen smpl_flag = rowmiss(lnnum_ccst_60_17_avg_pri1 pdiv_aa ${geovars} ${ethfrac} ${ethpolr} ${colhist} ${legalor} ${exconst} ${polregs} ${oilprod} ${popsize} ${ypercap}) ;
qui replace smpl_flag = (smpl_flag == 0) ;

/***************************************/
/* Generate the descriptive statistics */
/***************************************/

estpost tabstat num_ccst_60_17_avg_pri1 pdiv_aa mdist_addis ${geovars} ${ethfrac} ${ethpolr} ${colhist} ${legalor} ${exconst} ${polregs} ${oilprod} ${popsize} ${ypercap} 
if smpl_flag == 1 & oldw == 1, statistics(mean sd p10 p90) columns(statistics) ;

esttab using "../../results/tables/xtab_stats.tex", replace 
  cell((mean(fmt(a2) label("Mean")) sd(fmt(a2) label("SD")) p10(fmt(a2) label("10th")) p90(fmt(a2) label("90th")))) 
  noobs label nomtitles nonumbers varwidth(50) booktabs fragment 
  prehead("\begin{tabular}{lrrrr}" "\toprule" "\multicolumn{3}{c}{}&\multicolumn{2}{c}{Percentile}\\" "\cmidrule{4-5}") 
  posthead("\midrule" "PANEL~A&\multicolumn{4}{c}{Old World sample (\$N=`e(N)'\$)}\\" "\cmidrule{2-5}") ;

estpost tabstat num_ccst_60_17_avg_pri1 pdiv_aa mdist_addis ${geovars} ${ethfrac} ${ethpolr} ${colhist} ${legalor} ${exconst} ${polregs} ${oilprod} ${popsize} ${ypercap} 
if smpl_flag == 1, statistics(mean sd p10 p90) columns(statistics) ;

esttab using "../../results/tables/xtab_stats.tex", append 
  cell((mean(fmt(a2) label(" ")) sd(fmt(a2) label(" ")) p10(fmt(a2) label(" ")) p90(fmt(a2) label(" ")))) 
  noobs label nomtitles nonumbers varwidth(50) booktabs fragment 
  posthead("PANEL~B&\multicolumn{4}{c}{Global sample (\$N=`e(N)'\$)}\\" "\cmidrule{2-5}") postfoot("\bottomrule" "\end{tabular}") ;

/*******************************/
/* Close the log file and exit */
/*******************************/

log close ;
exit ;
