/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/******************************************************************************************************/
/* FIGURE: Migratory Distance from East Africa and Observed Genetic Diversity across Ethnic Homelands */
/******************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/**************************/
/* Specify a color scheme */
/**************************/

global RGBcolor1 "215 48 39" ;
global RGBcolor2 "252 141 89" ;
global RGBcolor3 "254 224 144" ;
global RGBcolor4 "224 243 248" ;
global RGBcolor5 "145 191 219" ;
global RGBcolor6 "69 117 180" ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/mtab_mdist.log", text replace ;

/*****************/
/* Load the data */
/*****************/

use "../../data/obs_rep.dta", clear ;

/***********************/
/* Generate the figure */
/***********************/

gen dist = migdist / 10 ;

xi: reg odiv dist ;

gen estsmpl = (e(sample) == 1) ;

local coef = string(_b[dist], "%8.3f") ;
local serr = string(_se[dist], "%8.3f") ;
local tsta = string(_b[dist] / _se[dist], "%8.3f") ;
local ptr2 = string(`e(r2)', "%8.3f") ;
local nobs = string(`e(N)', "%8.0g") ;

twoway (scatter odiv dist if estsmpl == 1 & cont == 1, msymbol(o) msize(medium) mfcolor("$RGBcolor1") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (scatter odiv dist if estsmpl == 1 & cont == 2, msymbol(o) msize(medium) mfcolor("$RGBcolor2") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (scatter odiv dist if estsmpl == 1 & cont == 3, msymbol(o) msize(medium) mfcolor("$RGBcolor3") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (scatter odiv dist if estsmpl == 1 & cont == 4, msymbol(o) msize(medium) mfcolor("$RGBcolor4") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (scatter odiv dist if estsmpl == 1 & cont == 5, msymbol(o) msize(medium) mfcolor("$RGBcolor5") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (scatter odiv dist if estsmpl == 1 & cont == 6, msymbol(o) msize(medium) mfcolor("$RGBcolor6") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
     (lfit    odiv dist if estsmpl == 1, clcolor(black) lstyle(refline) lwidth(medthick)),
    ylabel(, labsize(small) glcolor(gs14) glwidth(medthin) nogrid)
    xlabel(, labsize(small))
    ytitle("")
    xtitle("")
    title("", size(small))
    subtitle("" " ", size(vsmall))
    l1title("" " ", size(vsmall))
    l2title("Genetic Diversity", size(small))
    b1title(" " "", size(vsmall))
    b2title("Migratory Distance from East Africa (in 10,000 km)", size(small))
    note(" " "Relationship in the global sample", span size(vsmall))
    caption("Slope coefficient = `coef' ; (robust) standard error = `serr' ; t-statistic = `tsta' ;" "partial R-squared = `ptr2' ; observations = `nobs'", span size(vsmall))
    legend(order(1 2 3 4 5 6) rows(1) label(1 "Africa") label(2 "Europe") label(3 "Asia") label(4 "Oceania") label(5 "N. America") label(6 "S. America") size(vsmall) position(6) region(style(none)))
    graphregion(color(white)) plotregion(color(white)) bgcolor(white) xsize(1) ysize(1) ;

graph export "../../results/figures/mfig_mdist.pdf", as(pdf) replace ;

/*******************************/
/* Close the log file and exit */
/*******************************/

log close ;

exit ;
