/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/******************************************************************************/
/* TABLE: Predicted Population Diversity and Conflict across Ethnic Homelands */
/******************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/mtab_prvlnc_pdiv.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/pred_rep.dta", clear ;
xi: reg lcsnm pdiv ${regions}, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate}, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} frac, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} pol, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} frac if cont != 5 & cont != 6 & cont != 4, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} pol if cont != 5 & cont != 6 & cont != 4, r ;
use "../../data/obs_rep.dta", clear ;
xi: ivreg2 lcsnm (odiv=migdist) ${regions} ${base} ${climate}, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
