/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/********************************************************************************************************************************/
/* TABLE: Predicted Population Diversity and Conflict across Ethnic Homelands – Robustness to Accounting for Spatial Dependence */
/********************************************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_sarar_pdiv.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/pred_rep.dta", clear ;

egen hid2_num = group(hid2) ;
xtset, clear ;
spset, clear ;
spset hid2_num ;
spset, modify coord(centroid_x centroid_y) ;
spmatrix create idistance dobj, normalize(spectral) replace ;
spmatrix summarize dobj ;
spmatrix save dobj using dobj.spmat, replace ;
spmatrix use dobj using dobj.spmat, replace ;

xi: spregress lcsnm pdiv ${regions}, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base}, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base} ${climate}, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base} ${climate} frac, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base} ${climate} pol, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base} ${climate} frac ${endog}, ml dvarlag(dobj) errorlag(dobj) ;
xi: spregress lcsnm pdiv ${regions} ${base} ${climate} pol ${endog}, ml dvarlag(dobj) errorlag(dobj) ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
