/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*****************************************************************************/
/* TABLE: Summary Statistics of Variables in the Ethnic-Group-Level Analyses */
/*****************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_stats.log", text replace ;

/*****************/
/* Load the data */
/*****************/

use "../../data/obs_rep.dta", clear ;

/***********************************************************************************************/
/* Rescale those RHS variables whose regression coefficients would otherwise appear as "0.000" */
/***********************************************************************************************/

replace rugg = 10^(-3)*rugg ;
replace elev = 10^(-3)*elev ;
replace elev_range = 10^(-3)*elev_range ;
replace postcal = 10^(-3)*postcal ;
replace postcal_range = 10^(-3)*postcal_range ;
replace distwater = 10^(-3)*distwater ;
replace yss = 10^(2)*yss ;
replace cdeaths = cdeaths/1000 ;

/****************************************/
/* Produce the first panel of the table */
/****************************************/

tabstat odiv pdiv csnm cnum cdeaths frac pol abslat rugg elev elev_range postcal postcal_range island distwater tmp pre yss malaria petro_dummy luminosity, statistics(mean sd count p10 p90) columns(statistics) ;

/*****************/
/* Load the data */
/*****************/

use "../../data/pred_rep.dta", clear ;

/***********************************************************************************************/
/* Rescale those RHS variables whose regression coefficients would otherwise appear as "0.000" */
/***********************************************************************************************/

replace rugg = 10^(-3)*rugg ;
replace elev = 10^(-3)*elev ;
replace elev_range = 10^(-3)*elev_range ;
replace postcal = 10^(-3)*postcal ;
replace postcal_range = 10^(-3)*postcal_range ;
replace distwater = 10^(-3)*distwater ;
replace yss = 10^(2)*yss ;
replace cdeaths = cdeaths/1000 ;

/*****************************************/
/* Produce the second panel of the table */
/*****************************************/

tabstat pdiv csnm cnum cdeaths frac pol abslat rugg elev elev_range postcal postcal_range island distwater tmp pre yss malaria petro_dummy luminosity, statistics(mean sd count p10 p90) columns(statistics) ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
