* Code for analysis in: "Fecundity, Fertility and Family Reconstitution Data", the Economic Journal, by Marc Klemp and Jacob Weisdorf.

cd "/Users/user/Data" // Set the path to the data files here

cap program drop calcconley
program define calcconley
	// This program requires the -plausexog- command. It can be installed with -ssc install plausexog-.
	local lowerbound = _b[siblings]*(-0.1)
	local upperbound = _b[siblings]*0.1
	plausexog uci sig `1' (siblings=p), gmin(`lowerbound') gmax(`upperbound') grid(2) level(`2') vce(cluster famid)
end

global cntrls1 male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na mma5_* agricultural industrial retail pmy20*
global cntrls2 male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na mma5_* agricultural industrial retail pmy20*
global cntrls3 male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na mma5_* agricultural industrial retail pmy20*
global cntrls3nobo male nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na mma5_* agricultural industrial retail pmy20*
global cntrls1pg male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na mma5_* agricultural industrial retail pmy20*
global cntrls2pg male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskillpg fskillpg_na mskillpg mskillpg_na mma5_* agricultural industrial retail pmy20*
global cntrls3pg male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskillpg fskillpg_na mskillpg mskillpg_na fsig fsig_na msig msig_na mma5_* agricultural industrial retail pmy20*
global cntrls1pfe male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na mma5_* parish_* pmy20*
global cntrls2pfe male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na mma5_* parish_* pmy20*
global cntrls3pfe male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na mma5_* parish_* pmy20*
global cntrls1yr male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na i.mma1 agricultural industrial retail i.pmy
global cntrls2yr male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na i.mma1 agricultural industrial retail i.pmy
global cntrls3yr male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na i.mma1 agricultural industrial retail i.pmy
global cntrlsnomarage male o_1 o_2 o_3 o_4 o_5 o_6 o_7 o_8 o_9 o_10 nonsun nonsun_na fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na agricultural industrial retail pmy20*
global cntrlsfamilylevel fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na mma5_* agricultural industrial retail pmy20*

*** Figures
* Figure 1
use "baseline.dta", clear
hist by if sig!=., width(25) percent graphregion(color(white)) xlabel(1550 1600 1650 1700 1750 1800 1850) ylabel(, nogrid) xtitle("Year") ytitle("Percentage of observations") start(1550) scale(1) xsize(1) ysize(1)
hist by if (skill!=. | occwealth!=.), width(25) percent graphregion(color(white)) xlabel(1550 1600 1650 1650 1700 1750 1800 1850) ylabel(, nogrid) xtitle("Year") ytitle("Percentage of observations") start(1550) scale(1) xsize(1) ysize(1)

* Figure 2
use "fig2.dta", clear
graph bar sibshipsize, over(mmacat, relabel(1 "Below 20" 2 "20-25" 3 "25-30" 4 "30-35" 5 "35 and above")) b2title("Maternal age at marriage", size(medsmall)) bar(1, /*color(black)*/) graphregion(color(white)) ylabel(, nogrid) ytitle("Average number of births")

* Figure 3
use "fig3.dta", clear
gen pweeks = p*52
hist pweeks, bin(130) xlabel(0 38 260) percent graphregion(color(white)) ylabel(, nogrid) xtitle("Weeks from marriage to first birth") ytitle("Percentage of observations")

*** Tables
* Table 1
use "p.dta", clear
stset p
stcox c.mma##c.mma pmy20_*, cluster(pmy) nohr
stcox fpoor fpoor_na pmy20_*, cluster(pmy) nohr
stcox fskill fskill_na mskill mskill_na pmy20_*, cluster(pmy) nohr
stcox fsig fsig_na msig msig_na pmy20_*, cluster(pmy) nohr
stcox agricultural industrial retail pmy20_*, cluster(pmy) nohr
stcox c.mma##c.mma fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na agricultural industrial retail pmy20_*, cluster(pmy) nohr

* Table 2
use "baseline.dta", clear
regress sig ${cntrls1} p, cluster(famid)
regress sig ${cntrls2} p, cluster(famid)
regress sig ${cntrls3} p, cluster(famid)
regress skill ${cntrls1} p, cluster(famid)
regress skill ${cntrls2} p, cluster(famid)
regress skill ${cntrls3} p, cluster(famid)
regress occwealth ${cntrls1} p, cluster(famid)
regress occwealth ${cntrls2} p, cluster(famid)
regress occwealth ${cntrls3} p, cluster(famid)

* Table 3
use "baseline.dta", clear
gen fsig_and_skill = fsig & fskill
regress sig ${cntrls1} c.p##(c.fsig_and_skill), cluster(famid) 
regress sig ${cntrls2} c.p##(c.fsig_and_skill), cluster(famid) 
regress sig ${cntrls3} c.p##(c.fsig_and_skill), cluster(famid) 
regress skill ${cntrls1} c.p##(c.fsig_and_skill), cluster(famid) 
regress skill ${cntrls2} c.p##(c.fsig_and_skill), cluster(famid) 
regress skill ${cntrls3} c.p##(c.fsig_and_skill), cluster(famid) 
regress occwealth ${cntrls1} c.p##(c.fsig_and_skill), cluster(famid) 
regress occwealth ${cntrls2} c.p##(c.fsig_and_skill), cluster(famid) 
regress occwealth ${cntrls3} c.p##(c.fsig_and_skill), cluster(famid) 

* Table 4
use "baseline.dta", clear
regress sig ${cntrls3} win_p, cluster(famid)
regress sig ${cntrls3} p if p<3+40/52, cluster(famid)
regress sig ${cntrls3} p ind_*, cluster(famid)
regress skill ${cntrls3} win_p, cluster(famid)
regress skill ${cntrls3} p if p<3+40/52, cluster(famid)
regress skill ${cntrls3} p ind_*, cluster(famid)
regress occwealth ${cntrls3} win_p, cluster(famid)
regress occwealth ${cntrls3} p if p<3+40/52, cluster(famid)
regress occwealth ${cntrls3} p ind_*, cluster(famid)

* Table 5
use "baseline.dta", clear
reg siblings ${cntrls3} p if (sig != .) & cf & flong != . & p != . & p>40/52, cluster(famid)
reg siblings ${cntrls3} p if (skill != .) & cf & flong != . & p != . & p>40/52, cluster(famid)
reg siblings ${cntrls3} p if (occwealth !=.) & cf & flong != . & p != . & p>40/52, cluster(famid)
reg siblings ${cntrls3} p if (skill != . | sig != . | occwealth !=.) & cf & flong != . & p != . & p>40/52, cluster(famid)

* Table 6
use "baseline.dta", clear
ivreg2 sig ${cntrls1} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls2} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls1} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls2} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls1} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls2} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings=p), cluster(famid) partial(mma5_* pmy20*)
/*
Note: To calculate the Conley Plausibly Exogenous p-value here and elsewhere, please run the user-defined program -calcconley "${cntrls1}" 0.99-
 after the relevant ivreg2-command. The first argument ("${cntrls1}" in the example, with quotes) is the set of control
	 variables while the second argument ("0.99" in the example, without quotes) is the significance level.
*/

* Table 7
use "baseline.dta", clear
ivreg2 sig ${cntrls3} (siblings=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} (siblings=p) if p<3+40/52, cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} ind_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} (siblings_imputed_first_long=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} (siblings_imputed_all_long=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings=p) if p<3+40/52, cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} ind_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings_imputed_first_long=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings_imputed_all_long=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings=p) if p<3+40/52, cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} ind_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings_imputed_first_long=win_p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings_imputed_all_long=p), cluster(famid) partial(mma5_* pmy20*)

* Table C1
use "baseline.dta", clear
* The siblings included in the analysis from the family can be identified with famid == 95765
br if famid == 95765

* Table C2
use "38weeks.dta", clear
regress sig ${cntrls1} p, cluster(famid)
regress sig ${cntrls2} p, cluster(famid)
regress sig ${cntrls3} p, cluster(famid)
regress skill ${cntrls1} p, cluster(famid)
regress skill ${cntrls2} p, cluster(famid)
regress skill ${cntrls3} p, cluster(famid)
regress occwealth ${cntrls1} p, cluster(famid)
regress occwealth ${cntrls2} p, cluster(famid)
regress occwealth ${cntrls3} p, cluster(famid)

* Table C3
use "baseline.dta", clear
replace mskill = . if mskill_na == 1
replace fskill = . if fskill_na == 1
replace fpoor = . if fpoor_na == 1
replace msig = . if msig_na == 1
replace fsig = . if fsig_na == 1
replace nonsun = . if nonsun_na == 1
tabstat siblings sig skill p male nonsun fskill mskill fsig msig flong mma agricultural industrial retail by, s(mean sd n p10 p90) columns(statistics)

* Table C4
use "baseline.dta", clear
ivreg2 sig ${cntrls1} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls2} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls1} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls2} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls1} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls2} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} (siblings_all=p), cluster(famid) partial(mma5_* pmy20*)

* Table C5
use "baseline.dta", clear
regress sig ${cntrls1} p by20_*, cluster(famid)
regress sig ${cntrls2} p by20_*, cluster(famid)
regress sig ${cntrls3} p by20_*, cluster(famid)
regress skill ${cntrls1} p by20_*, cluster(famid)
regress skill ${cntrls2} p by20_*, cluster(famid)
regress skill ${cntrls3} p by20_*, cluster(famid)
regress occwealth ${cntrls1} p by20_*, cluster(famid)
regress occwealth ${cntrls2} p by20_*, cluster(famid)
regress occwealth ${cntrls3} p by20_*, cluster(famid)

* Table C6
use "baseline.dta", clear
regress skillpg ${cntrls1pg} p, cluster(famid)
regress skillpg ${cntrls2pg} p, cluster(famid)
regress skillpg ${cntrls3pg} p, cluster(famid)

* Table C7
use "baseline.dta", clear
regress sig ${cntrls1} p fma5_*, cluster(famid)
regress sig ${cntrls2} p fma5_*, cluster(famid)
regress sig ${cntrls3} p fma5_*, cluster(famid)
regress skill ${cntrls1} p fma5_*, cluster(famid)
regress skill ${cntrls2} p fma5_*, cluster(famid)
regress skill ${cntrls3} p fma5_*, cluster(famid)
regress occwealth ${cntrls1} p fma5_*, cluster(famid)
regress occwealth ${cntrls2} p fma5_*, cluster(famid)
regress occwealth ${cntrls3} p fma5_*, cluster(famid)

* Table C8
use "baseline.dta", clear
ivreg2 sig ${cntrls1} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls2} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 sig ${cntrls3} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls1} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls2} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 skill ${cntrls3} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls1} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls2} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)
ivreg2 occwealth ${cntrls3} fma5_* (siblings=p), cluster(famid) partial(mma5_* pmy20*)

* Table C9
use "baseline.dta", clear
regress sig ${cntrls1} p foccwealth_*, cluster(famid)
regress sig ${cntrls2} p foccwealth_*, cluster(famid)
regress sig ${cntrls3} p foccwealth_*, cluster(famid)
regress skill ${cntrls1} p foccwealth_*, cluster(famid)
regress skill ${cntrls2} p foccwealth_*, cluster(famid)
regress skill ${cntrls3} p foccwealth_*, cluster(famid)
regress occwealth ${cntrls1} p foccwealth_*, cluster(famid)
regress occwealth ${cntrls2} p foccwealth_*, cluster(famid)
regress occwealth ${cntrls3} p foccwealth_*, cluster(famid)

* Table C10
use "baseline.dta", clear
gen relbirthorder = (birthorder - 1)/(siblings)
regress sig ${cntrls3nobo} p, cluster(famid)
regress sig ${cntrls3nobo} p birthorder, cluster(famid)
regress sig ${cntrls3nobo} p relbirthorder, cluster(famid)
regress skill ${cntrls3nobo} p, cluster(famid)
regress skill ${cntrls3nobo} p birthorder, cluster(famid)
regress skill ${cntrls3nobo} p relbirthorder, cluster(famid)
regress occwealth ${cntrls3nobo} p, cluster(famid)
regress occwealth ${cntrls3nobo} p birthorder, cluster(famid)
regress occwealth ${cntrls3nobo} p relbirthorder, cluster(famid)

* Table C11
use "baseline.dta", clear
regress sig ${cntrls1pfe} p, cluster(famid)
regress sig ${cntrls2pfe} p, cluster(famid)
regress sig ${cntrls3pfe} p, cluster(famid)
regress skill ${cntrls1pfe} p, cluster(famid)
regress skill ${cntrls2pfe} p, cluster(famid)
regress skill ${cntrls3pfe} p, cluster(famid)
regress occwealth ${cntrls1pfe} p, cluster(famid)
regress occwealth ${cntrls2pfe} p, cluster(famid)
regress occwealth ${cntrls3pfe} p, cluster(famid)

* Table C12
use "baseline.dta", clear
regress sig ${cntrls1yr} p, cluster(famid)
regress sig ${cntrls2yr} p, cluster(famid)
regress sig ${cntrls3yr} p, cluster(famid)
regress skill ${cntrls1yr} p, cluster(famid)
regress skill ${cntrls2yr} p, cluster(famid)
regress skill ${cntrls3yr} p, cluster(famid)
regress occwealth ${cntrls1yr} p, cluster(famid)
regress occwealth ${cntrls2yr} p, cluster(famid)
regress occwealth ${cntrls3yr} p, cluster(famid)

* Table C13
use "baseline.dta", clear
gen occwealth3orabove = occwealth >= 3 if occwealth != .
logit sig ${cntrls1} p, cluster(famid)
logit sig ${cntrls2} p, cluster(famid)
logit sig ${cntrls3} p, cluster(famid)
logit skill ${cntrls1} p, cluster(famid)
logit skill ${cntrls2} p, cluster(famid)
logit skill ${cntrls3} p, cluster(famid)
logit occwealth3orabove ${cntrls1} p, cluster(famid)
logit occwealth3orabove ${cntrls2} p, cluster(famid)
logit occwealth3orabove ${cntrls3} p, cluster(famid)

* Table C14
* Robustness of Table 3
use "baseline.dta", clear
gen fsig_and_skill = fsig & fskill
gen fsig_or_skill_na = fsig_na | fskill_na
regress sig ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress sig ${cntrls3} c.win_p##(c.fsig_and_skill), cluster(famid)
regress sig ${cntrls3} c.win_p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress sig ${cntrls3} c.p##(c.fsig_and_skill) if p<3+40/52, cluster(famid)
regress sig ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na) if p<3+40/52, cluster(famid)
regress skill ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress skill ${cntrls3} c.win_p##(c.fsig_and_skill), cluster(famid)
regress skill ${cntrls3} c.win_p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress skill ${cntrls3} c.p##(c.fsig_and_skill) if p<3+40/52, cluster(famid)
regress skill ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na) if p<3+40/52, cluster(famid)
regress occwealth ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress occwealth ${cntrls3} c.win_p##(c.fsig_and_skill), cluster(famid)
regress occwealth ${cntrls3} c.win_p##(c.fsig_and_skill c.fsig_or_skill_na), cluster(famid)
regress occwealth ${cntrls3} c.p##(c.fsig_and_skill) if p<3+40/52, cluster(famid)
regress occwealth ${cntrls3} c.p##(c.fsig_and_skill c.fsig_or_skill_na) if p<3+40/52, cluster(famid)

* Table C15
use "baseline.dta", clear
regress sig ${cntrls3} p *mmq_*, cluster(famid)
regress sig ${cntrls3} p *fbbq_*, cluster(famid)
regress sig ${cntrls3} p *mmq_* *fbbq_*, cluster(famid)
regress skill ${cntrls3} p *mmq_*, cluster(famid)
regress skill ${cntrls3} p *fbbq_*, cluster(famid)
regress skill ${cntrls3} p *mmq_* *fbbq_*, cluster(famid)
regress occwealth ${cntrls3} p *mmq_*, cluster(famid)
regress occwealth ${cntrls3} p *fbbq_*, cluster(famid)
regress occwealth ${cntrls3} p *mmq_* *fbbq_*, cluster(famid)

* Table C16
use "baseline.dta", clear
regress sig ${cntrls3} p ma_aggregate_wage, cluster(famid)
regress sig ${cntrls3} p m_ma_aggregate_wage, cluster(famid)
regress sig ${cntrls3} p p_ma_aggregate_wage, cluster(famid)
regress sig ${cntrls3} p ma_aggregate_wage m_ma_aggregate_wage p_ma_aggregate_wage, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_wage, cluster(famid)
regress skill ${cntrls3} p m_ma_aggregate_wage, cluster(famid)
regress skill ${cntrls3} p p_ma_aggregate_wage, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_wage m_ma_aggregate_wage p_ma_aggregate_wage, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_wage, cluster(famid)
regress occwealth ${cntrls3} p m_ma_aggregate_wage, cluster(famid)
regress occwealth ${cntrls3} p p_ma_aggregate_wage, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_wage m_ma_aggregate_wage p_ma_aggregate_wage, cluster(famid)

* Table C17
use "baseline.dta", clear
regress sig ${cntrls3} p ma_aggregate_temp, cluster(famid)
regress sig ${cntrls3} p m_ma_aggregate_temp, cluster(famid)
regress sig ${cntrls3} p p_ma_aggregate_temp, cluster(famid)
regress sig ${cntrls3} p ma_aggregate_temp m_ma_aggregate_temp p_ma_aggregate_temp, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_temp, cluster(famid)
regress skill ${cntrls3} p m_ma_aggregate_temp, cluster(famid)
regress skill ${cntrls3} p p_ma_aggregate_temp, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_temp m_ma_aggregate_temp p_ma_aggregate_temp, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_temp, cluster(famid)
regress occwealth ${cntrls3} p m_ma_aggregate_temp, cluster(famid)
regress occwealth ${cntrls3} p p_ma_aggregate_temp, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_temp m_ma_aggregate_temp p_ma_aggregate_temp, cluster(famid)

* Table C18
use "baseline.dta", clear
regress sig ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr, cluster(famid)
regress sig ${cntrls3} p m_ma_aggregate_cdr m_ma_aggregate_cbr, cluster(famid)
regress sig ${cntrls3} p p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)
regress sig ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr m_ma_aggregate_cdr m_ma_aggregate_cbr p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr, cluster(famid)
regress skill ${cntrls3} p m_ma_aggregate_cdr m_ma_aggregate_cbr, cluster(famid)
regress skill ${cntrls3} p p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)
regress skill ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr m_ma_aggregate_cdr m_ma_aggregate_cbr p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr, cluster(famid)
regress occwealth ${cntrls3} p m_ma_aggregate_cdr m_ma_aggregate_cbr, cluster(famid)
regress occwealth ${cntrls3} p p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)
regress occwealth ${cntrls3} p ma_aggregate_cdr ma_aggregate_cbr m_ma_aggregate_cdr m_ma_aggregate_cbr p_ma_aggregate_cdr p_ma_aggregate_cbr, cluster(famid)

* Table C19
use "baseline.dta", clear
regress sig ${cntrlsnomarage} p, cluster(famid)
regress sig ${cntrlsnomarage} p *msa5_*, cluster(famid)
regress sig ${cntrlsnomarage} p *msa5_* *mma5*, cluster(famid)
regress skill ${cntrlsnomarage} p, cluster(famid)
regress skill ${cntrlsnomarage} p *msa5_*, cluster(famid)
regress skill ${cntrlsnomarage} p *msa5_* *mma5*, cluster(famid)
regress occwealth ${cntrlsnomarage} p, cluster(famid)
regress occwealth ${cntrlsnomarage} p *msa5_*, cluster(famid)
regress occwealth ${cntrlsnomarage} p *msa5_* *mma5*, cluster(famid)

* Table C20
use "baseline.dta", clear
regress sig ${cntrls1} p if male==1, cluster(famid)
regress sig ${cntrls2} p if male==1, cluster(famid)
regress sig ${cntrls3} p if male==1, cluster(famid)
regress skill ${cntrls1} p if male==1, cluster(famid)
regress skill ${cntrls2} p if male==1, cluster(famid)
regress skill ${cntrls3} p if male==1, cluster(famid)
regress occwealth ${cntrls1} p if male==1, cluster(famid)
regress occwealth ${cntrls2} p if male==1, cluster(famid)
regress occwealth ${cntrls3} p if male==1, cluster(famid)

* Table C21
use "baseline.dta", clear
regress sig ${cntrls1} p fl5_* ml5_*, cluster(famid)
regress sig ${cntrls2} p fl5_* ml5_*, cluster(famid)
regress sig ${cntrls3} p fl5_* ml5_*, cluster(famid)
regress skill ${cntrls1} p fl5_* ml5_*, cluster(famid)
regress skill ${cntrls2} p fl5_* ml5_*, cluster(famid)
regress skill ${cntrls3} p fl5_* ml5_*, cluster(famid)
regress occwealth ${cntrls1} p fl5_* ml5_*, cluster(famid)
regress occwealth ${cntrls2} p fl5_* ml5_*, cluster(famid)
regress occwealth ${cntrls3} p fl5_* ml5_*, cluster(famid)

* Table C22
use "heckit.dta", clear
probit select_lit ${cntrls3} death_date_na mar_date_na, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
regress sig ${cntrls3} p invmills, cluster(famid)
drop z invmills

probit select_skill ${cntrls3} death_date_na mar_date_na, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
regress skill ${cntrls3} p invmills, cluster(famid)
drop z invmills

probit select_occwealth ${cntrls3} death_date_na mar_date_na, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
regress occwealth ${cntrls3} p invmills, cluster(famid)
drop z invmills

* Table C23
use "spacing.dta", clear
stset spacing
stcox p pmy20_* c.mma##c.mma, cluster(famid) nohr
stcox p pmy20_* fpoor fpoor_na, cluster(famid) nohr
stcox p pmy20_* fskill fskill_na mskill mskill_na, cluster(famid) nohr
stcox p pmy20_* fsig fsig_na msig msig_na, cluster(famid) nohr
stcox p pmy20_* agricultural industrial retail, cluster(famid) nohr
stcox p pmy20_* c.mma##c.mma fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na agricultural industrial retail, cluster(famid) nohr

* Table C24
use "spacing.dta", clear
stset spacing
stcox p maab pmy20_* c.mma##c.mma, cluster(famid) nohr
stcox p maab pmy20_* fpoor fpoor_na, cluster(famid) nohr
stcox p maab pmy20_* fskill fskill_na mskill mskill_na, cluster(famid) nohr
stcox p maab pmy20_* fsig fsig_na msig msig_na, cluster(famid) nohr
stcox p maab pmy20_* agricultural industrial retail, cluster(famid) nohr
stcox p maab pmy20_* c.mma##c.mma fpoor fpoor_na fskill fskill_na mskill mskill_na fsig fsig_na msig msig_na agricultural industrial retail, cluster(famid) nohr

* Table C25
use "baseline.dta", clear
gen firststagesample1 = sig != .
gen firststagesample2 = skill != .
gen firststagesample3 = occwealth != .
egen famidtagsample1 = tag(famid firststagesample1)
egen famidtagsample2 = tag(famid firststagesample2)
egen famidtagsample3 = tag(famid firststagesample3)
egen famidtagsample4 = tag(famid)
reg siblings ${cntrlsfamilylevel} p if famidtagsample1 & firststagesample1, cluster(famid)
reg siblings ${cntrlsfamilylevel} p if famidtagsample2 & firststagesample2, cluster(famid)
reg siblings ${cntrlsfamilylevel} p if famidtagsample3 & firststagesample3, cluster(famid)
reg siblings ${cntrlsfamilylevel} p if famidtagsample4, cluster(famid)

* Table C26
use "heckit.dta", clear
probit select_lit ${cntrls3} death_date_na mar_date_na p, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
ivreg2 sig ${cntrls3} (siblings=p) invmills, cluster(famid) partial(mma5_* pmy20*)
drop z invmills

probit select_skill ${cntrls3} death_date_na mar_date_na p, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
ivreg2 skill ${cntrls3} (siblings=p) invmills, cluster(famid) partial(mma5_* pmy20*)
drop z invmills

probit select_occwealth ${cntrls3} death_date_na mar_date_na p, cluster(famid)
predict z, xb
gen invmills = normalden(z) / normal(z)
label var invmills "Inverse Mills Ratio"
ivreg2 occwealth ${cntrls3} (siblings=p) invmills, cluster(famid) partial(mma5_* pmy20*)
drop z invmills
