% Simulation of Ramsey Model With a Public Sector using Relaxation algorithm.
% Note: The instantaneous utility function is of CRRA form. 
% The production function is a Cobb-Douglas with a shift parameter i.e.
% Y=B*K^alpha*(A*L)^(1-alpha) where B is parameter.

clear all

globalpar                           % Initializes global parameters
parini                              % Load the parameter values
relaxsetting                        % Load the settings

[guess, start, errorcode] = initrelax(@funcODE, @funcSTAT, n, n1, n3, nu, y, M, statev);       

if errorcode==0
    
    [t, x]=relax(@funcODE, @funcSTAT, @funcINI, @funcfinal, n, n1, n3, nu, guess, M, start, Endcond, maxit, tol, damp, dampfac);
    
    for i=1:M
        x(normal,i)=x(normal,i)./x(normal,end);
    end;
    
    varex;                              % Extracts the variables
 
    [EVa EVe Jac]=eigDAS(@funcODE, @funcSTAT, x(:,end));
    disp(['Eigenvalues: ',num2str(EVa')]);disp([' ']);
    
end