%relaxsetting.m

% NOTE:
% Under 'Steady state values' you can adjust the right-hand sides if the true 
% formula for the steady-state value is changed, say because a tax parameter is 
% added to the model. 
% A few lines below this you see "statev(1)=0.xy;
% The initial value of capital is at xy% of its steady state value". Here you 
% replace "0.xy" by 0.50 if you want the predetermined variable to start at 50% 
% of its steady-state value. 
% Under "number of mesh points" you may increase the number of mesh points if the convergence towards
% steady state seems awkward.

% number of initial boundary conditions ( = number of state variables)
n1=1;

%number of differential equations (Note: number of final boundary
%conditions equals n-n1)
n=2;

% number of static equations to be solved simultanously
n3=0;

%number of mesh points
M=100;

%number of variables altogether
N=n+n3;         %(Do not change)

%Normalization of variables
normal=[];  %no normalisation

% Steady state values
kss = ((delta+(rho+gA*theta)/(1-taur))/(alpha*B))^(1/(alpha-1));
css = B*kss^alpha-gamma-(nPop+delta+gA)*kss;

%guess of final steady state values
y=ones(N,1);
y(1)=kss;    %k
y(2)=css;    %c

% Here you can change the initial value of the state variables
statev=ones(N,1);
statev(1)=0.6;      % E.g. statev(1)=0.5 means that the first state variable 
                    % starts at 50% of the steady state value

Endcond=0;

tol=10^-9;      %tolerance for the Newton procedure
maxit=50;       %Maximum number of iterations
nu=0.05;        %Parameter for time transformation
damp=1;         %Dampening factor of the Newton procedure. The dampening factor will be 
dampfac=2;      %multiplied by the factor dampfac in every iteration until it equals 1
