% Rationalbubble.m by Niklas Brnager 21-12-2010
%
% This script will simulate n bubbles for m periods. See the resulting
% price processes in "price" 7array.


n=10;                               % Number of bubbles
m=50;                               % Number of periods
q=0.95;                             % The probability that the bubble survives
div=10*ones(n,m+1);                 % Dividend process
r=0.04;                             % Bond rate
bubble = 50*ones(n,m+1);            % Bubble
fundvar = zeros(n,m);               % Fundamental values
price = zeros(n,m);                 % Market price

% The Bubble:

a = unifrnd(0,1,[n m]);

for i=1:n
    for j=1:m
         if a(i,j) > q
            % Bubble bursts
            bubble(i,j+1) = 0;
        else
            bubble(i,j+1) = ((1+r)/q)*bubble(i,j);
        end
    end
end

% Divided process:

b = normrnd(0,0.1,[n m]);

for i=1:n
   
    for j=2:m+1
        div(i,j) = div(i,j-1) +  b(i,j-1);
    end
end

% Price process

for i=(n+1):(m+1)*n
    fundvar(i-n) = div(i)/r;
    price(i-n) = fundvar(i-n)+bubble(i);
end
