%relaxsetting.m

% number of initial boundary conditions ( = number of state variables)
n1=2;

%number of differential equations (Note: number of final boundary
%conditions equals n-n1)
n=3;

% number of static equations to be solved simultanously
n3=0;

%number of mesh points
M=120;

%number of variables altogether
N=n+n3;         %(Do not change)

%Normalization of variables
normal=[];

% calculation of steady state values - used for guessing
varzss = ((theta+lambda)*(1-alpha)*gamma+(theta*alpha+1-alpha)*lambda*nPop)/(alpha*(1-alpha*(1+lambda)))+(rho+delta)/alpha;
varxss = ((theta+(1-alpha)*lambda-alpha)*(1-alpha)*gamma+(theta*alpha*lambda+((1-alpha)*lambda-alpha)*(1-alpha))*nPop)/(alpha*(1-alpha*(1+lambda)))+(rho+(1-alpha)*delta)/alpha;
stemp = 1-varxss/varzss;
varuss = (((1-alpha)*(gamma+nPop))/(1-alpha*(1+lambda)))/stemp;

%guess of final steady state values
y=ones(N,1);
y(1) = varzss;
y(2) = varuss;
y(3) = varxss;

%Introduction of a shock (here, a deviation from the steady state
%relation in (k,h) induces transitional dynamics)
statev=ones(N,1);
statev(1)=0.5;
statev(2)=0.5;

%--------------------------------------------------------------------------
%Specification, which differential equations are used for constructing the
%final boundary conditions. 
Endcond=[3];

tol=10^-9;       %tolerance for the Newton procedure
maxit=50;       %Maximum number of iterations
nu=0.04;          %Parameter for time transformation
damp=1;          %Dampening factor of the Newton procedure. The dampening factor will be 
dampfac=2;       %multiplied by the factor dampfac in every iteration until it equals 1
