** BOUNTY OF THE SEA AND LONG-RUN DEVELOPMENT
** Anne Sofie B. Knudsen, Carl-Johan Dalgaard, and Pablo Selaya
** Journal of Economic Growth 2020
** Cross country data

version 15
cls
clear all	
set more off

cd "`c(pwd)'"

********************************************************************************************
** Main text tables: Tables 4, 6-12 + Figures 3, 5 + Appendix tables A2a, A3-A11, A13-A15 **
********************************************************************************************

use data_03_crosscountry, clear

gen ly2005 = ln(GDP2005)-ln(Pop2005)
gen ln_pd1500 = ln(pd1500)
gen lcoastalpop50 = ln(1 + coastalpop50)
gen lcoastalpop100 = ln(1 + coastalpop100)
gen lcoastalland50 = ln(1 + coastland50)
gen y2005 = exp(ly2005)
gen inlandw_area = inlandwaterwayskm/area
gen coast_area = coastlinelengthkm/area
gen ports_area = natports/area


**************************************
** Main text tables: Tables 4, 6-12 **
**************************************


** Table 4

reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta


** Table 6

reg ly2005 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg ly2005 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg ly2005 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg ly2005 suit50_mfish eez_area soilsuit area abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ly2005 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ly2005 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if e(sample) & eez_>0, r beta
reg ly2005 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ly2005 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta


** Table 7

reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ly2005 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta


** Table 8

reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area yst_aa africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ly2005 aarobsuit50uw eez_area robsuit50_uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aarobsuit50uw eez_area robsuit50_uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 cb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 cb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if eez_>0, r beta


** Table 9a

reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area abslat coastland100 land100cr africa asia oceania americas if e(sample), r beta
reg lcoastalpop1500100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop1500100 robsuit50_uw eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop1500100 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta


** Table 9b

reg lcoastalpop100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop100 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lcoastalpop100 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lcoastalpop100 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lcoastalpop100 suit50_mfish eez_area soilsuit area abslat coastland100 land100cr africa asia oceania americas if e(sample), r beta
reg lcoastalpop100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop100 robsuit50_uw eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastalpop100 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta


** Table 10a

reg lurb1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg lurb1500 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lurb1500 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lurb1500 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lurb1500 suit50_mfish eez_area soilsuit area abslat landlocked land100cr africa asia oceania americas if e(sample), r beta
reg lurb1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg lurb1500 robsuit50_uw eez_area soilsuit area abslat landlocked land100cr land100cr africa asia oceania americas, r beta
reg lurb1500 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta


** Table 10b

reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area if e(sample), r beta
reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area africa asia oceania americas if e(sample), r beta
reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area yst_aa africa asia oceania americas if e(sample), r beta
reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area abslat landlocked land100cr land100cr africa asia oceania americas if e(sample), r beta
reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg lagsh1900 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg lagsh1900 aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta


** Table 11a

reg indu_year aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg indu_year aasuit50_mfish eez_area aasoilsuit area if e(sample), r beta
reg indu_year aasuit50_mfish eez_area aasoilsuit area africa asia oceania americas if e(sample), r beta
reg indu_year aasuit50_mfish eez_area aasoilsuit area yst_aa africa asia oceania americas if e(sample), r beta
reg indu_year aasuit50_mfish eez_area aasoilsuit area abslat landlocked land100cr land100cr africa asia oceania americas if e(sample), r beta
reg indu_year aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg indu_year aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg indu_year aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta


** Table 11b

reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area if e(sample), r beta
reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area africa asia oceania americas if e(sample), r beta
reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area yst_aa africa asia oceania americas if e(sample), r beta
reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area abslat landlocked land100cr land100cr africa asia oceania americas if e(sample), r beta
reg fertilitydeC aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg fertilitydeC aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg fertilitydeC aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta


** Table 12a

reg ly2005 indu_year aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 indu_year aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 indu_year aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 indu_year aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta


** Table 12b

reg ly2005 fertilitydeC aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 fertilitydeC aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 fertilitydeC aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta
reg ly2005 fertilitydeC aacb10_suit50_mfish areacbuff10 aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas if e(sample) , r beta


******************
** Figures 3, 5 **
******************


** Figure 3: full specification Table.column: 6.5, 6.7, A9.5, A9.7

reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
avplot aasuit50_mfish, saving(3a,replace) nodraw note(Results from Table 6 col 5. X = baseline.) yti("(log) GDP per cap 2005 | X") xti("Ancestry adjusted BoS index | X") graphr(fc(gs16)) graphr(c(gs16)) 
reg ly2005 aarobsuit50uw eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
avplot aarobsuit50uw, saving(3b,replace) nodraw note(Results from Table 6 col 7. X = baseline.) yti("(log) GDP per cap 2005 | X") xti("Ancestry adjusted BoS index (robust) | X") graphr(fc(gs16)) graphr(c(gs16)) 
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas , r beta
avplot aasuit50_mfish, saving(3c,replace) nodraw note(Results from Table A9 col 5. X = AG except Soc Inf.) yti("(log) GDP per cap 2005 | X") xti("Ancestry adjusted BoS index | X") graphr(fc(gs16)) graphr(c(gs16)) 
reg ly2005 aarobsuit50uw eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas , r beta
avplot aarobsuit50uw, saving(3d,replace) nodraw note(Results from Table A9 col 7. X = AG except Soc Inf.) yti("(log) GDP per cap 2005 | X") xti("Ancestry adjusted BoS index (robust) | X") graphr(fc(gs16)) graphr(c(gs16)) 
graph combine 3a.gph 3b.gph 3c.gph 3d.gph, saving(3,replace) graphr(fc(gs16)) graphr(c(gs16)) 
graph export Figure3.pdf, replace
erase 3.gph
erase 3a.gph 
erase 3b.gph 
erase 3c.gph 
erase 3d.gph


** Figure 5: Table 10B col 5

reg lagsh1900 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
avplot aasuit50_mfish, saving(5,replace) note(Results from Table 10B col 5.) yti("1900 employment share in agriculture | X") xti("Ancestry adjusted BoS index | X") graphr(fc(gs16)) graphr(c(gs16)) 
graph export Figure5.pdf, replace
erase 5.gph


******************************************
** Appendix tables A2a, A3-A11, A13-A15 **
******************************************


** Table A2a

fsum pd1500 y2005 suit50_mfish aasuit50_mfish robsuit50_uw aarobsuit50uw cb10_suit50_mfish aacb10_suit50_mfish eez_area areacbuff10 soilsuit aasoilsuit area aaarea yst yst_aa abslat landlocked land100cr if (pd1500!=. | y2005!=.) & (soilsuit!=. & suit50_mfish!=.), label


** Table A3

reg ln_pd1500 suit50_mfish eez_area soilsuit area if europe, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr if e(sample), r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area if europe, r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst if e(sample), r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr if e(sample), r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area if europe, r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst if e(sample), r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr if e(sample), r beta


** Table A4

reg ln_pd1500 suit50_mfish eez_area soilsuit area if asia, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr if e(sample), r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area if asia, r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst if e(sample), r beta
reg ln_pd1500 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr if e(sample), r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area if asia, r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst if e(sample), r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr if e(sample), r beta


** Table A5

reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_area>0, r beta
reg ln_pd1500 cals50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 cals50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_area>0, r beta
reg ln_pd1500 fats50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 fats50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_area>0, r beta
reg ln_pd1500 prs50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 prs50 eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if eez_area>0, r beta


** Table A6

reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst ln_arable ln_abslat ln_suitavg africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_arable ln_abslat ln_suitavg africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst ln_arable ln_abslat ln_suitavg africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr rough ln_yst ln_arable ln_abslat ln_suitavg africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample) & eez_>0, r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst ln_arable ln_abslat ln_suitavg africa asia oceania americas, r beta
reg ln_pd1500 robsuit50_uw eez_area pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ln_pd1500 robsuit50_uw eez_area pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample) & eez_>0, r beta
reg ln_pd1500 suit50_mfish eez_area pdiv pdiv_sqr ln_yst ln_arable ln_abslat ln_suitavg africa asia oceania americas, r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ln_pd1500 cb10_suit50_mfish areacbuff10 pdiv pdiv_sqr rough ln_yst ln_temp ln_precip ln_arable ln_abslat africa asia oceania americas if e(sample) & eez_>0, r beta


** Table A7

reg ln_pd1500 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst biodiv abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst shelf abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst estuary abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst tidal abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst island abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst distcr abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst coast_area abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst inlandw_area abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst ports_area abslat landlocked land100cr africa asia oceania americas, r beta
reg ln_pd1500 suit50_mfish eez_area soilsuit area yst ports_area biodiv tidal shelf estuary island distcr coast_area inlandw_area abslat landlocked land100cr africa asia oceania americas, r beta


** Table A8

reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aaprs50 eez_area aasoilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aafats50 eez_area aasoilsuit area yst abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas , r beta
reg ly2005 aacals50 eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas , r beta
reg ly2005 aaprs50 eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas , r beta
reg ly2005 aafats50 eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas, r beta


** Table A9

reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr  africa asia oceania americas biodiv, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas shelf, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas estuary, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas tidal , r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas island, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas distcr, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas coast_area, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas inlandw_a, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas ports_area, r beta
reg ly2005 aasuit50_mfish eez_area aasoilsuit area yst_aa abslat landlocked land100cr africa asia oceania americas ports_area biodiv tidal shelf estuary island distcr coast_area inlandw_area , r beta


** Table A10

reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas, r beta
reg ly2005 aasuit50_mfish eez_area africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr yst_aa ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr yst_aa ln_arable ln_abslat socinf africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac yst_aa ln_arable ln_abslat socinf africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac yst_aa ln_arable ln_abslat socinf legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aarobsuit50uw eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aarobsuit50uw eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta


** Table A11

reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr yst_aa ln_arable ln_abslat africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr yst_aa ln_arable ln_abslat socinf africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac yst_aa ln_arable ln_abslat socinf africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac yst_aa ln_arable ln_abslat socinf legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aasuit50_mfish eez_area suit50_mfish eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aarobsuit50uw eez_area robsuit50_uw eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aarobsuit50uw eez_area robsuit50_uw eez_area pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 cb10_suit50_mfish areacbuff10 pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat socinf opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta
reg ly2005 aacb10_suit50_mfish areacbuff10 cb10_suit50_mfish areacbuff10 pdiv_aa pdiv_aa_sqr efrac peuro malfal kgatr distcr yst_aa ln_arable ln_abslat opec legor_uk legor_fr legor_so legor_ge legor_sc pprotest pcatholic pmuslim pother africa asia oceania americas if e(sample), r beta


** Table A13

reg lcoastallight100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastallight100 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lcoastallight100 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lcoastallight100 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lcoastallight100 suit50_mfish eez_area soilsuit area abslat coastland100 land100cr africa asia oceania americas if e(sample), r beta
reg lcoastallight100 suit50_mfish eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastallight100 robsuit50_uw eez_area soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta
reg lcoastallight100 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat coastland100 land100cr africa asia oceania americas, r beta


** Table A14a

reg lcoastalpop150050 suit50_mfish eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop150050 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lcoastalpop150050 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lcoastalpop150050 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lcoastalpop150050 suit50_mfish eez_area soilsuit area abslat coastland50 land100cr africa asia oceania americas if e(sample), r beta
reg lcoastalpop150050 suit50_mfish eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop150050 robsuit50_uw eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop150050 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta


** Table A14b

reg lcoastalpop50 suit50_mfish eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop50 suit50_mfish eez_area soilsuit area if e(sample), r beta
reg lcoastalpop50 suit50_mfish eez_area soilsuit area africa asia oceania americas if e(sample), r beta
reg lcoastalpop50 suit50_mfish eez_area soilsuit area yst africa asia oceania americas if e(sample), r beta
reg lcoastalpop50 suit50_mfish eez_area soilsuit area abslat coastland50 land100cr africa asia oceania americas if e(sample), r beta
reg lcoastalpop50 suit50_mfish eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop50 robsuit50_uw eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop50 robsuit50_uw eez_area soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta
reg lcoastalpop50 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat coastland50 land100cr africa asia oceania americas, r beta


** Table A15

reg lagsh1900 suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg lagsh1900 robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg lagsh1900 cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg indu_year suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg indu_year robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg indu_year cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg fertilitydeC suit50_mfish eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg fertilitydeC robsuit50_uw eez_area soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta
reg fertilitydeC cb10_suit50_mfish areacbuff10 soilsuit area yst abslat landlocked land100cr africa asia oceania americas if pnative>.90, r beta

