** BOUNTY OF THE SEA AND LONG RUN DEVELOPMENT
** Anne Sofie B. Knudsen, Carl-Johan Dalgaard, and Pablo Selaya
** Journal of Economic Growth 2020
** Pixel level data

version 15
cls
clear
set more off

cd "`c(pwd)'"

******************************************************************************
** Main text tables: Table 5 + Appendix tables A2a, A12 + Conley std errors **
******************************************************************************

use data_04_pixel, clear

gen lpd1500_all = ln(pd1500_all)
gen lpop_area_all = ln(pop_area_all)
gen llightnewarea_all = ln(lightnewarea_all)


*******************************
** Main text tables: Table 5 **
*******************************


** Table 5

areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev, abs(iso) r
gen sample5 = e(sample)
reg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea if sample5, r beta
areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea if sample5, abs(iso) r
areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist if sample5, abs(iso) r
areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea b200_estuary b200_shelf b200_tidal if sample5, abs(iso) r
areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea abslat elev if sample5, abs(iso) r
areg lpd1500_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if sample5, abs(iso) r
areg lpd1500_all b100_suit50_robuw raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if sample5, abs(iso) r
areg lpd1500_all b10_suit50_mfish raman buf10_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if sample5, abs(iso) r


******************************
** Appendix tables A2a, A12 **
******************************

** Table A2b

fsum pd1500_all pop_area_all lightnewarea_all b100_suit50_mfish b100_suit50_robuw b10_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if (pd1500_all!=. | pop_area_all!=. | lightnewarea_all!=.) & (b100_suit50_mfish!=. & raman!=.), label


** Table A12a

areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev, abs(iso) r
gen samplea12a = e(sample)
reg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea if samplea12a, r beta
areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea if samplea12a, abs(iso) r
areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist if samplea12a, abs(iso) r
areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea b200_estuary b200_shelf b200_tidal if samplea12a, abs(iso) r
areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea abslat elev if samplea12a, abs(iso) r
areg lpop_area_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12a, abs(iso) r
areg lpop_area_all b100_suit50_robuw raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12a, abs(iso) r
areg lpop_area_all b10_suit50_mfish raman buf10_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12a, abs(iso) r


** Table A12b

areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev, abs(iso) r
gen samplea12b = e(sample)
reg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea if samplea12b, r beta
areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea if samplea12b, abs(iso) r
areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist if samplea12b, abs(iso) r
areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea b200_estuary b200_shelf b200_tidal if samplea12b, abs(iso) r
areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea abslat elev if samplea12b, abs(iso) r
areg llightnewarea_all b100_suit50_mfish raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12b, abs(iso) r
areg llightnewarea_all b100_suit50_robuw raman buf100_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12b, abs(iso) r
areg llightnewarea_all b10_suit50_mfish raman buf10_area pixelarea coast_dist harbor_dist b200_estuary b200_shelf b200_tidal abslat elev if samplea12b, abs(iso) r


***********************************************************
** Compute Conley Std errors for Tables 5 and A12a, A12b **
***********************************************************

global bos		b100_suit50_mfish 
global areas	buf100_area pixelarea
global bos2		b100_suit50_robuw 
global areas2	buf100_area pixelarea
global bos3		b10_suit50_mfish 
global areas3	buf10_area pixelarea
global ag		raman
global coast 	coast_dist harbor_dist
global coast2 	b200_estuary b200_shelf b200_tidal
global geo 		abslat elev

gen year = 2000
gen const = 1
encode isocode, g(iso)
cap drop sample*


** Table 5

local table 5

	local dep lpd1500_all

	noi areg `dep' $bos $ag $areas $coast $coast2 $geo, abs(iso) r
	gen sample`table' = e(sample)

	noi reg `dep' $bos $ag $areas if sample`table', r
		qui reg `dep' $ag $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $bos $ag $areas if sample`table', r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui reg `dep' $bos $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $ag $bos $areas if sample`table', r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag

	foreach c in "$areas" "$areas $coast" "$areas $coast2" "$areas $geo" "$areas $coast $coast2 $geo" {
		noi areg `dep' $bos $ag `c' if sample`table', abs(iso) r
			qui areg `dep' $ag `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $bos $ag `c' if sample`table', abs(iso) r
			predict ebos if sample`table', resid
			ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local boscoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
			noi di "pvalconley_bos = " `pvcbos'
			drop ey ebos 
			qui areg `dep' $bos `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $ag $bos `c' if sample`table', abs(iso) r
			predict eag if sample`table', resid
			ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local agcoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
			noi di "pvalconley_ag = " `pvcag'
			drop ey eag 
	}

	noi areg `dep' $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 

	noi areg `dep' $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 

	
** Table A12a

local table a12a

	local dep lpop_area_all

	noi areg `dep' $bos $ag $areas $coast $coast2 $geo, abs(iso) r
	gen sample`table' = e(sample)

	noi reg `dep' $bos $ag $areas if sample`table', r
		qui reg `dep' $ag $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $bos $ag $areas if sample`table', r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui reg `dep' $bos $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $ag $bos $areas if sample`table', r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag

	foreach c in "$areas" "$areas $coast" "$areas $coast2" "$areas $geo" "$areas $coast $coast2 $geo" {
		noi areg `dep' $bos $ag `c' if sample`table', abs(iso) r
			qui areg `dep' $ag `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $bos $ag `c' if sample`table', abs(iso) r
			predict ebos if sample`table', resid
			ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local boscoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
			noi di "pvalconley_bos = " `pvcbos'
			drop ey ebos 
			qui areg `dep' $bos `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $ag $bos `c' if sample`table', abs(iso) r
			predict eag if sample`table', resid
			ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local agcoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
			noi di "pvalconley_ag = " `pvcag'
			drop ey eag 
	}

	noi areg `dep' $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 

	noi areg `dep' $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 


** Table A12b

local table a12b

	local dep llightnewarea_all

	noi areg `dep' $bos $ag $areas $coast $coast2 $geo, abs(iso) r
	gen sample`table' = e(sample)

	noi reg `dep' $bos $ag $areas if sample`table', r
		qui reg `dep' $ag $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $bos $ag $areas if sample`table', r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui reg `dep' $bos $areas if sample`table', r
		predict ey if sample`table', resid
		qui reg $ag $bos $areas if sample`table', r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag

	foreach c in "$areas" "$areas $coast" "$areas $coast2" "$areas $geo" "$areas $coast $coast2 $geo" {
		noi areg `dep' $bos $ag `c' if sample`table', abs(iso) r
			qui areg `dep' $ag `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $bos $ag `c' if sample`table', abs(iso) r
			predict ebos if sample`table', resid
			ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local boscoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
			noi di "pvalconley_bos = " `pvcbos'
			drop ey ebos 
			qui areg `dep' $bos `c' if sample`table', abs(iso) r
			predict ey if sample`table', resid
			qui areg $ag $bos `c' if sample`table', abs(iso) r
			predict eag if sample`table', resid
			ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
			mat b = e(b)
			local agcoef = b[1,1]
			mat V = e(V)
			local conleyse = sqrt(V[1,1])
			local df = e(df_r)
			local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
			noi di "pvalconley_ag = " `pvcag'
			drop ey eag 
	}

	noi areg `dep' $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos2 $ag $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos2 $areas2 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 

	noi areg `dep' $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		qui areg `dep' $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $bos3 $ag $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ebos if sample`table', resid
		ols_spatial_HAC ey ebos const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local boscoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcbos = 2*ttail(`df',abs(`boscoef'/`conleyse'))
		noi di "pvalconley_bos = " `pvcbos'
		drop ey ebos 
		qui areg `dep' $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict ey if sample`table', resid
		qui areg $ag $bos3 $areas3 $coast $coast2 $geo if sample`table', abs(iso) r
		predict eag if sample`table', resid
		ols_spatial_HAC ey eag const if sample`table', lat(latitude) lon(longitude) time(year) panel(iso) dist(400) 
		mat b = e(b)
		local agcoef = b[1,1]
		mat V = e(V)
		local conleyse = sqrt(V[1,1])
		local df = e(df_r)
		local pvcag = 2*ttail(`df',abs(`agcoef'/`conleyse'))
		noi di "pvalconley_ag = " `pvcag'
		drop ey eag 
